/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractClickSelectedLineStringsTool
extends SpecifyFeaturesTool {
    protected static final String NO_SELECTED_LINESTRINGS_HERE_MESSAGE = "No selected LineStrings here";

    public AbstractClickSelectedLineStringsTool() {
        this.setViewClickBuffer(10);
    }

    protected void warnLayerNotEditable(Layer layer) {
        this.getWorkbench().getFrame().warnUser(layer.getName() + " is not editable");
    }

    public String getName() {
        return super.getName().replaceAll("Line String", "LineString");
    }

    protected Coordinate getModelSource() {
        return this.getModelDestination();
    }

    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        return null;
    }

    protected Point getModelClickPoint() {
        return new GeometryFactory().createPoint(this.getModelDestination());
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory().createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory().createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        Collection nearbyLineStringFeatures = CollectionUtil.select((Collection)CollectionUtil.concatenate(this.layerToSpecifiedFeaturesMap().values()), (Block)new Block(){

            public Object yield(Object feature) {
                return AbstractClickSelectedLineStringsTool.this.getPanel().getSelectionManager().getFeaturesWithSelectedItems().contains(feature) && ((Feature)feature).getGeometry() instanceof LineString ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (nearbyLineStringFeatures.isEmpty()) {
            this.getWorkbench().getFrame().warnUser(NO_SELECTED_LINESTRINGS_HERE_MESSAGE);
            return;
        }
        this.gestureFinished(nearbyLineStringFeatures);
    }

    private EnableCheckFactory checkFactory() {
        return new EnableCheckFactory(this.getWorkbench().getContext());
    }

    protected abstract void gestureFinished(Collection var1) throws NoninvertibleTransformException;

    protected Layer layer(Feature feature, Map layerToSpecifiedFeaturesMap) {
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            Collection features = (Collection)layerToSpecifiedFeaturesMap.get(layer);
            if (!features.contains(feature)) continue;
            return layer;
        }
        Assert.shouldNeverReachHere();
        return null;
    }
}

