/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class MultiClickTool
extends AbstractCursorTool {
    private List coordinates = new ArrayList();
    private Coordinate tentativeCoordinate;
    private boolean closeRing = false;
    private CoordinateListMetrics metrics = null;
    private LayerViewPanel panel;
    private WorkbenchFrame frame;
    private boolean activated = false;
    private KeyListener keyListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 8) {
                if (MultiClickTool.this.coordinates.size() > 1) {
                    MultiClickTool.this.coordinates.remove(MultiClickTool.this.coordinates.size() - 1);
                }
                MultiClickTool.this.panel.repaint();
            }
        }
    };

    protected void setMetricsDisplay(CoordinateListMetrics metrics) {
        this.metrics = metrics;
    }

    protected CoordinateListMetrics getMetrics() {
        return this.metrics;
    }

    protected void setCloseRing(boolean closeRing) {
        this.closeRing = closeRing;
    }

    public List getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public void cancelGesture() {
        super.cancelGesture();
        this.coordinates.clear();
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if (e.getClickCount() == 1) {
                this.tentativeCoordinate = this.snap(e.getPoint());
                this.redrawShape();
            }
            super.mouseReleased(e);
            if (this.isFinishingRelease(e)) {
                this.finishGesture();
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected void mouseLocationChanged(MouseEvent e) {
        try {
            if (this.coordinates.isEmpty()) {
                return;
            }
            this.tentativeCoordinate = this.snap(e.getPoint());
            this.redrawShape();
            this.displayMetrics(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void displayMetrics(MouseEvent e) throws NoninvertibleTransformException {
        if (this.metrics == null) {
            return;
        }
        if (this.isShapeOnScreen()) {
            ArrayList<Coordinate> currentCoordinates = new ArrayList<Coordinate>(this.getCoordinates());
            currentCoordinates.add(this.getPanel().getViewport().toModelCoordinate(e.getPoint()));
            this.metrics.displayMetrics(currentCoordinates, this.getPanel());
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseLocationChanged(e);
    }

    protected void add(Coordinate c) {
        this.coordinates.add(c);
    }

    public void mousePressed(MouseEvent e) {
        try {
            super.mousePressed(e);
            Assert.isTrue((e.getClickCount() > 0 ? 1 : 0) != 0);
            if (e.getClickCount() != 1) {
                return;
            }
            this.add(this.snap(e.getPoint()));
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Shape getShape() throws NoninvertibleTransformException {
        Point2D firstPoint = this.getPanel().getViewport().toViewPoint((Coordinate)this.coordinates.get(0));
        GeneralPath path = new GeneralPath();
        path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
        for (int i = 1; i < this.coordinates.size(); ++i) {
            Coordinate nextCoordinate = (Coordinate)this.coordinates.get(i);
            Point2D nextPoint = this.getPanel().getViewport().toViewPoint(nextCoordinate);
            path.lineTo((int)nextPoint.getX(), (int)nextPoint.getY());
        }
        Point2D tentativePoint = this.getPanel().getViewport().toViewPoint(this.tentativeCoordinate);
        path.lineTo((int)tentativePoint.getX(), (int)tentativePoint.getY());
        if (this.closeRing) {
            path.lineTo((int)firstPoint.getX(), (int)firstPoint.getY());
        }
        return path;
    }

    protected boolean isFinishingRelease(MouseEvent e) {
        return e.getClickCount() == 2;
    }

    protected Coordinate[] toArray(List coordinates) {
        return coordinates.toArray(new Coordinate[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishGesture() throws Exception {
        this.clearShape();
        try {
            this.fireGestureFinished();
        }
        finally {
            this.coordinates.clear();
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.frame != null) {
            this.frame.removeEasyKeyListener(this.keyListener);
            this.activated = false;
        }
    }

    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.panel = layerViewPanel;
        this.frame = AbstractCursorTool.workbenchFrame(this.panel);
        if (this.frame != null & !this.activated) {
            this.frame.addEasyKeyListener(this.keyListener);
            this.activated = true;
        }
    }
}

