/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NoteStyle;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.snap.SnapToFeaturesPolicy;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class NoteTool
extends NClickTool {
    private LayerViewPanel panel;
    private JTextArea textArea;
    private Mode mode;
    private ImageIcon icon = IconLoader.icon("sticky.png");
    private Cursor cursor = GUIUtil.createCursorFromIcon(this.icon.getImage());

    public NoteTool() {
        super(1);
        this.panel = this.getPanel();
        this.getSnapManager().addPolicies(Collections.singleton(new SnapToFeaturesPolicy()));
        this.textArea = NoteStyle.createTextArea();
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (NoteTool.this.panelContainsTextArea()) {
                    boolean doit;
                    boolean bl = doit = NoteTool.this.textArea.getText().trim().length() > 0;
                    if (doit) {
                        NoteTool.this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
                    }
                    NoteTool.this.removeTextAreaFromPanel();
                    if (doit) {
                        NoteTool.this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
                    }
                }
            }
        });
    }

    public void deactivate() {
        if (this.panelContainsTextArea()) {
            boolean doit;
            boolean bl = doit = this.textArea.getText().trim().length() > 0;
            if (doit) {
                this.getPanel().getLayerManager().getUndoableEditReceiver().startReceiving();
            }
            this.removeTextAreaFromPanel();
            if (doit) {
                this.getPanel().getLayerManager().getUndoableEditReceiver().stopReceiving();
            }
        }
        super.deactivate();
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Feature noteFeatureAtClick = this.noteFeature(this.getModelDestination());
        this.removeTextAreaFromPanel();
        this.mode = this.mode(noteFeatureAtClick, this.getModelDestination());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    NoteTool.this.addTextAreaToPanel(NoteTool.this.mode.location());
                }
                catch (NoninvertibleTransformException e) {
                    NoteTool.this.getPanel().getContext().handleThrowable(e);
                }
            }
        });
    }

    private Mode mode(Feature noteFeatureAtClick, Coordinate click) {
        return noteFeatureAtClick == null ? new CreateMode(click) : new EditMode(noteFeatureAtClick);
    }

    private Feature noteFeature(Coordinate click) {
        return this.noteFeature(new Envelope(click, new Coordinate(click.x - 80.0 / this.scale(), click.y + 30.0 / this.scale())));
    }

    private Feature noteFeature(Envelope envelope) {
        return (Feature)this.firstOrNull(this.layer().getFeatureCollectionWrapper().query(envelope));
    }

    private Object firstOrNull(Collection items) {
        return !items.isEmpty() ? items.iterator().next() : null;
    }

    private double scale() {
        return this.getPanel().getViewport().getScale();
    }

    private void addTextAreaToPanel(Coordinate location) throws NoninvertibleTransformException {
        this.layer().setVisible(true);
        if (this.getPanel().getLayout() != null) {
            this.getPanel().setLayout(null);
        }
        this.textArea.setText(this.mode.initialText());
        this.textArea.setBackground(this.layer().getBasicStyle().getFillColor());
        this.getPanel().add(this.textArea);
        this.textArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                JTextArea textArea = (JTextArea)e.getSource();
                int ht = textArea.getPreferredSize().height;
                int wt = textArea.getPreferredSize().width;
                if (ht < 30) {
                    ht = 30;
                }
                if (wt < 80) {
                    wt = 80;
                }
                int x = textArea.getBounds().x;
                int y = textArea.getBounds().y;
                textArea.setBounds(x, y, wt, ht);
            }
        });
        int ht = this.textArea.getPreferredSize().height;
        int wt = this.textArea.getPreferredSize().width;
        if (ht < 30) {
            ht = 30;
        }
        if (wt < 80) {
            wt = 80;
        }
        this.textArea.setBounds((int)this.getPanel().getViewport().toViewPoint(location).getX(), (int)this.getPanel().getViewport().toViewPoint(location).getY(), wt, ht);
        this.textArea.requestFocus();
    }

    private boolean panelContainsTextArea() {
        return Arrays.asList(this.getPanel().getComponents()).contains(this.textArea);
    }

    private void removeTextAreaFromPanel() {
        if (!this.panelContainsTextArea()) {
            return;
        }
        this.mode.commit(this.textArea.getText().trim());
        this.getPanel().remove(this.textArea);
        this.getPanel().superRepaint();
    }

    private void disableAutomaticInitialZooming() {
        this.getPanel().setViewportInitialized(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer layer() {
        LayerManager layerManager = this.getPanel().getLayerManager();
        if (layerManager.getLayer("Notes") != null) {
            return layerManager.getLayer("Notes");
        }
        Layer noteLayer = new Layer("Notes", Color.yellow.brighter().brighter(), (FeatureCollection)new FeatureDataset(NoteStyle.createFeatureSchema()), layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            noteLayer.addStyle(new NoteStyle());
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
        layerManager.addLayer(StandardCategoryNames.SYSTEM, noteLayer);
        return noteLayer;
    }

    public Icon getIcon() {
        return this.icon;
    }

    protected Shape getShape() throws NoninvertibleTransformException {
        return null;
    }

    private class EditMode
    extends Mode {
        public EditMode(Feature noteFeature) {
            super(noteFeature);
        }

        public void commit(final String text) {
            final Date modifiedDate = new Date();
            final Date oldModifiedDate = (Date)this.getNoteFeature().getAttribute("MODIFIED");
            final String oldText = this.getNoteFeature().getString("TEXT");
            NoteTool.this.execute(new UndoableCommand(NoteTool.this.getName()){

                public void execute() {
                    EditMode.this.update(EditMode.this.getNoteFeature(), text, modifiedDate, NoteTool.this.layer());
                }

                public void unexecute() {
                    EditMode.this.update(EditMode.this.getNoteFeature(), oldText, oldModifiedDate, NoteTool.this.layer());
                }
            });
        }

        private void update(Feature noteFeature, String text, Date modifiedDate, Layer layer) {
            noteFeature.setAttribute("MODIFIED", (Object)modifiedDate);
            noteFeature.setAttribute("TEXT", (Object)text);
            layer.getLayerManager().fireFeaturesChanged(Collections.singleton(noteFeature), FeatureEventType.ATTRIBUTES_MODIFIED, layer);
        }

        public String initialText() {
            return this.getNoteFeature().getString("TEXT");
        }
    }

    private class CreateMode
    extends Mode {
        public CreateMode(final Coordinate location) {
            super((Feature)new BasicFeature(NoteTool.this.layer().getFeatureCollectionWrapper().getFeatureSchema()){
                {
                    super(x0);
                    this.setAttribute("CREATED", new Date());
                    this.setAttribute("GEOMETRY", new GeometryFactory().createPoint(location));
                }
            });
        }

        public void commit(String text) {
            if (text.length() > 0) {
                NoteTool.this.disableAutomaticInitialZooming();
                this.getNoteFeature().setAttribute("MODIFIED", (Object)new Date());
                this.getNoteFeature().setAttribute("TEXT", (Object)text);
                EditTransaction transaction = new EditTransaction((Collection)Collections.EMPTY_LIST, NoteTool.this.getName(), NoteTool.this.layer(), NoteTool.this.isRollingBackInvalidEdits(), true, NoteTool.this.getPanel());
                transaction.createFeature(this.getNoteFeature());
                transaction.commit();
            }
        }

        public String initialText() {
            return "";
        }
    }

    private abstract class Mode {
        private Feature noteFeature;

        public Mode(Feature noteFeature) {
            this.noteFeature = noteFeature;
        }

        public Coordinate location() {
            return this.noteFeature.getGeometry().getCoordinate();
        }

        public abstract void commit(String var1);

        protected Feature getNoteFeature() {
            return this.noteFeature;
        }

        public abstract String initialText();
    }
}

