/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.cursortool.FeatureInfoTool;
import com.vividsolutions.jump.workbench.ui.cursortool.LeftClickFilter;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;

public class QuasimodeTool
extends DelegatingTool {
    private boolean altKeyDown = false;
    private boolean mouseDown = false;
    private Cursor cursor;
    private KeyListener keyListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.keyStateChanged(e);
        }

        public void keyReleased(KeyEvent e) {
            this.keyStateChanged(e);
        }

        private void keyStateChanged(KeyEvent e) {
            QuasimodeTool.this.altKeyDown = e.isAltDown();
            QuasimodeTool.this.setTool(e);
        }
    };
    private WindowAdapter windowListener = new WindowAdapter(){

        public void windowActivated(WindowEvent e) {
            super.windowActivated(e);
            QuasimodeTool.this.setTool(new KeyEvent(QuasimodeTool.this.panel, 401, 0L, 0, 0, '\uffff'));
        }
    };
    private KeyEvent currentKeyEvent = null;
    private LayerViewPanel panel;
    private WorkbenchFrame frame;
    private HashMap keySpecToToolMap = new HashMap();

    public QuasimodeTool(CursorTool defaultTool) {
        super(defaultTool);
        this.add(new ModifierKeySpec(false, false, false), defaultTool);
        this.cursor = defaultTool.getCursor();
    }

    private CursorTool getDefaultTool() {
        return (CursorTool)this.keySpecToToolMap.get(new ModifierKeySpec(false, false, false));
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    private CursorTool getTool(KeyEvent e) {
        CursorTool tool = (CursorTool)this.keySpecToToolMap.get(new ModifierKeySpec(e.isControlDown(), e.isShiftDown(), e.isAltDown() || e.isMetaDown()));
        return tool != null ? tool : this.getDefaultTool();
    }

    private void setTool(KeyEvent e) {
        if (!this.mouseDown) {
            this.cursor = this.getTool(e).getCursor();
            this.panel.setCursor(this.cursor);
            this.currentKeyEvent = e;
            this.setDelegate(this.getTool(e));
        }
    }

    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        this.panel = panel;
        this.frame = AbstractCursorTool.workbenchFrame(panel);
        if (this.frame != null) {
            this.frame.addEasyKeyListener(this.keyListener);
            this.frame.addWindowListener(this.windowListener);
            this.setTool(new KeyEvent(panel, 401, 0L, 0, 0, '\uffff'));
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.mouseDown = true;
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.mouseDown = false;
    }

    public void deactivate() {
        if (!this.altKeyDown) {
            super.deactivate();
            if (this.frame != null) {
                this.frame.removeEasyKeyListener(this.keyListener);
                this.frame.removeWindowListener(this.windowListener);
            }
        }
    }

    public QuasimodeTool add(ModifierKeySpec keySpec, CursorTool tool) {
        if (this.keySpecToToolMap.containsKey(keySpec)) {
            return this;
        }
        this.keySpecToToolMap.put(keySpec, tool != null ? (tool.isRightMouseButtonUsed() ? tool : new LeftClickFilter(tool)) : null);
        return this;
    }

    public static QuasimodeTool addStandardQuasimodes(CursorTool tool) {
        QuasimodeTool quasimodeTool = tool instanceof QuasimodeTool ? (QuasimodeTool)tool : new QuasimodeTool(tool);
        quasimodeTool.add(new ModifierKeySpec(false, false, true), new ZoomTool());
        quasimodeTool.add(new ModifierKeySpec(false, true, true), new PanTool());
        SelectFeaturesTool selectFeaturesTool = new SelectFeaturesTool(){

            protected boolean selectedLayersOnly() {
                return false;
            }
        };
        quasimodeTool.add(new ModifierKeySpec(true, false, false), selectFeaturesTool);
        quasimodeTool.add(new ModifierKeySpec(true, true, false), selectFeaturesTool);
        quasimodeTool.add(new ModifierKeySpec(true, false, true), new FeatureInfoTool());
        return quasimodeTool;
    }

    public static class ModifierKeySpec {
        private boolean needsShift;
        private boolean needsAltOrMeta;
        private boolean needsControl;

        public ModifierKeySpec(boolean needsControl, boolean needsShift, boolean needsAltOrMeta) {
            this.needsControl = needsControl;
            this.needsShift = needsShift;
            this.needsAltOrMeta = needsAltOrMeta;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ModifierKeySpec)) {
                return false;
            }
            ModifierKeySpec other = (ModifierKeySpec)obj;
            return this.needsControl == other.needsControl && this.needsShift == other.needsShift && this.needsAltOrMeta == other.needsAltOrMeta;
        }
    }
}

