/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.cursortool.Animations;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;

public class DeleteVertexTool
extends SpecifyFeaturesTool {
    private EnableCheckFactory checkFactory;
    private GeometryEditor geometryEditor = new GeometryEditor();

    public DeleteVertexTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.setViewClickBuffer(5);
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory.createAtLeastNItemsMustBeSelectedCheck(1))) {
            return;
        }
        if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
            return;
        }
        final ArrayList verticesDeleted = new ArrayList();
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layer : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            transactions.add(this.createTransaction(layer, verticesDeleted));
        }
        int emptyGeometryCount = EditTransaction.emptyGeometryCount(transactions);
        if (emptyGeometryCount > 0) {
            this.getPanel().getContext().warnUser(I18N.get((String)"ui.cursortool.editing.DeleteVertexTool.cancelled-deletion-would-result-in-empty-geometry"));
            return;
        }
        if (verticesDeleted.isEmpty()) {
            this.getPanel().getContext().warnUser(I18N.get((String)"ui.cursortool.editing.DeleteVertexTool.no-selection-handles-here"));
            return;
        }
        EditTransaction.commit(transactions, new EditTransaction.SuccessAction(){

            public void run() {
                try {
                    Animations.drawExpandingRings(DeleteVertexTool.this.getPanel().getViewport().toViewPoints(verticesDeleted), true, Color.red, DeleteVertexTool.this.getPanel(), new float[]{15.0f, 15.0f});
                }
                catch (Throwable t) {
                    DeleteVertexTool.this.getPanel().getContext().warnUser(t.toString());
                }
            }
        });
    }

    protected EditTransaction createTransaction(Layer layer, final ArrayList verticesDeleted) throws NoninvertibleTransformException {
        final Geometry box = EnvelopeUtil.toGeometry((Envelope)this.getBoxInModelCoordinates());
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                if (DeleteVertexTool.this.wasClick() && !verticesDeleted.isEmpty()) {
                    Assert.isTrue((verticesDeleted.size() == 1 ? 1 : 0) != 0);
                    return geometryWithSelectedItems;
                }
                if (!box.getEnvelopeInternal().intersects(geometryWithSelectedItems.getEnvelopeInternal())) {
                    return geometryWithSelectedItems;
                }
                Collection verticesInBox = VerticesInFencePlugIn.verticesInFence(selectedItems, box, true);
                if (DeleteVertexTool.this.wasClick() && !verticesInBox.isEmpty()) {
                    verticesDeleted.add(verticesInBox.iterator().next());
                } else {
                    verticesDeleted.addAll(verticesInBox);
                }
                return DeleteVertexTool.this.geometryEditor.deleteVertices(geometryWithSelectedItems, verticesInBox);
            }
        }, this.getPanel(), this.getPanel().getContext(), this.getName(), layer, this.isRollingBackInvalidEdits(), false);
        return transaction;
    }

    public Cursor getCursor() {
        return DeleteVertexTool.createCursor(IconLoader.icon("DeleteCursor.gif").getImage());
    }

    public Icon getIcon() {
        return IconLoader.icon("DeleteVertex.gif");
    }
}

