/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class FeatureDrawingUtil {
    private LayerNamePanelProxy layerNamePanelProxy;
    private GeometryEditor editor = new GeometryEditor();

    private Collection selectedFeaturesContaining(Polygon polygon, LayerViewPanel panel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            return new ArrayList();
        }
        ArrayList<Feature> selectedFeaturesContainingPolygon = new ArrayList<Feature>();
        for (Feature feature : panel.getSelectionManager().getFeaturesWithSelectedItems(this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer())) {
            if (feature.getGeometry().getClass() == GeometryCollection.class || !feature.getGeometry().getEnvelopeInternal().contains(polygon.getEnvelopeInternal()) || !feature.getGeometry().contains((Geometry)polygon)) continue;
            selectedFeaturesContainingPolygon.add(feature);
        }
        return selectedFeaturesContainingPolygon;
    }

    private void createHole(Polygon hole, Collection features, Layer layer, LayerViewPanel panel, boolean rollingBackInvalidEdits, String transactionName) {
        Assert.isTrue((hole.getNumInteriorRing() == 0 ? 1 : 0) != 0);
        EditTransaction transaction = new EditTransaction(features, transactionName, layer, rollingBackInvalidEdits, false, panel);
        for (int i = 0; i < transaction.size(); ++i) {
            transaction.setGeometry(i, transaction.getGeometry(i).difference((Geometry)hole));
        }
        transaction.commit();
    }

    public FeatureDrawingUtil(LayerNamePanelProxy layerNamePanelProxy) {
        this.layerNamePanelProxy = layerNamePanelProxy;
    }

    private Layer layer(LayerViewPanel layerViewPanel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            Layer layer = layerViewPanel.getLayerManager().addLayer(StandardCategoryNames.WORKING, I18N.get((String)"ui.cursortool.editing.FeatureDrawingUtil.new"), AddNewLayerPlugIn.createBlankFeatureCollection());
            layer.setEditable(true);
            layerViewPanel.getContext().warnUser(I18N.get((String)"ui.cursortool.editing.FeatureDrawingUtil.no-layer-is-editable-creating-new-editable-layer"));
        }
        return this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer();
    }

    public UndoableCommand createAddCommand(Geometry geometry, boolean rollingBackInvalidEdits, LayerViewPanel layerViewPanel, AbstractCursorTool tool) {
        if (rollingBackInvalidEdits && !geometry.isValid()) {
            layerViewPanel.getContext().warnUser(I18N.get((String)"ui.cursortool.editing.FeatureDrawingUtil.draw-feature-tool-topology-error"));
            return null;
        }
        layerViewPanel.setViewportInitialized(true);
        final Layer layer = this.layer(layerViewPanel);
        final Feature feature = FeatureUtil.toFeature((Geometry)this.editor.removeRepeatedPoints(geometry), (FeatureSchema)layer.getFeatureCollectionWrapper().getFeatureSchema());
        return new UndoableCommand(tool.getName()){

            public void execute() {
                layer.getFeatureCollectionWrapper().add(feature);
            }

            public void unexecute() {
                layer.getFeatureCollectionWrapper().remove(feature);
            }
        };
    }

    public CursorTool prepare(final AbstractCursorTool drawFeatureTool, boolean allowSnapping) {
        drawFeatureTool.setColor(Color.red);
        if (allowSnapping) {
            drawFeatureTool.allowSnapping();
        }
        return new DelegatingTool(drawFeatureTool){

            public String getName() {
                return drawFeatureTool.getName();
            }

            public Cursor getCursor() {
                if (Toolkit.getDefaultToolkit().getBestCursorSize(32, 32).equals(new Dimension(0, 0))) {
                    return Cursor.getDefaultCursor();
                }
                return Toolkit.getDefaultToolkit().createCustomCursor(IconLoader.icon("Pen.gif").getImage(), new Point(1, 31), drawFeatureTool.getName());
            }
        };
    }

    public void drawRing(Polygon polygon, boolean rollingBackInvalidEdits, AbstractCursorTool tool, LayerViewPanel panel) {
        Collection selectedFeaturesContainingPolygon = this.selectedFeaturesContaining(polygon, panel);
        if (selectedFeaturesContainingPolygon.isEmpty()) {
            AbstractPlugIn.execute(this.createAddCommand((Geometry)polygon, rollingBackInvalidEdits, panel, tool), panel);
        } else {
            this.createHole(polygon, selectedFeaturesContainingPolygon, this.layer(panel), panel, rollingBackInvalidEdits, tool.getName());
        }
    }

    private Collection selectedFeaturesMatchingEndPoint(LineString lineString, LayerViewPanel panel) {
        if (this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer() == null) {
            return new ArrayList();
        }
        ArrayList<Feature> selectedFeaturesMatchingEndPoints = new ArrayList<Feature>();
        for (Feature feature : panel.getSelectionManager().getFeaturesWithSelectedItems(this.layerNamePanelProxy.getLayerNamePanel().chooseEditableLayer())) {
            LineString lineGeom;
            if (!(feature.getGeometry() instanceof LineString) || !(lineGeom = (LineString)feature.getGeometry()).getCoordinate().equals((Object)lineString.getCoordinate()) && !lineGeom.getCoordinate().equals((Object)lineString.getCoordinateN(lineString.getNumPoints() - 1)) && !lineGeom.getCoordinateN(lineGeom.getNumPoints() - 1).equals((Object)lineString.getCoordinate()) && !lineGeom.getCoordinateN(lineGeom.getNumPoints() - 1).equals((Object)lineString.getCoordinateN(lineString.getNumPoints() - 1))) continue;
            selectedFeaturesMatchingEndPoints.add(feature);
        }
        return selectedFeaturesMatchingEndPoints;
    }

    public LineString reverse(LineString lineString) {
        CoordinateList coordList = new CoordinateList(lineString.getCoordinates());
        Collections.reverse(coordList);
        return new GeometryFactory().createLineString(coordList.toCoordinateArray());
    }

    public LineString concatLineStrings(LineString ls1, LineString ls2) {
        CoordinateList coordList1 = new CoordinateList(ls1.getCoordinates());
        CoordinateList coordList2 = new CoordinateList(ls2.getCoordinates());
        coordList1.remove(coordList1.size() - 1);
        coordList1.addAll((Collection)coordList2);
        return new GeometryFactory().createLineString(coordList1.toCoordinateArray());
    }

    public LineString mergeLineStrings(LineString ls1, LineString ls2) {
        if (ls1.getCoordinateN(ls1.getNumPoints() - 1).equals((Object)ls2.getCoordinate())) {
            return this.concatLineStrings(ls1, ls2);
        }
        if (ls1.getCoordinateN(ls1.getNumPoints() - 1).equals((Object)ls2.getCoordinateN(ls2.getNumPoints() - 1))) {
            return this.concatLineStrings(ls1, this.reverse(ls2));
        }
        if (ls1.getCoordinate().equals((Object)ls2.getCoordinate())) {
            return this.concatLineStrings(this.reverse(ls2), ls1);
        }
        if (ls1.getCoordinate().equals((Object)ls2.getCoordinateN(ls2.getNumPoints() - 1))) {
            return this.concatLineStrings(ls2, ls1);
        }
        return ls2;
    }

    public void drawLineString(LineString newLineString, boolean rollingBackInvalidEdits, AbstractCursorTool tool, LayerViewPanel panel) {
        Collection matchingLineStringFeatures = this.selectedFeaturesMatchingEndPoint(newLineString, panel);
        if (matchingLineStringFeatures.size() == 0) {
            AbstractPlugIn.execute(this.createAddCommand((Geometry)newLineString, rollingBackInvalidEdits, panel, tool), panel);
        } else {
            LineString oldLineString = null;
            Iterator iter = matchingLineStringFeatures.iterator();
            EditTransaction transaction = new EditTransaction(matchingLineStringFeatures, tool.getName(), this.layer(panel), rollingBackInvalidEdits, true, panel);
            LineString empty = new GeometryFactory().createLineString(new Coordinate[0]);
            for (int i = 0; i < transaction.size(); ++i) {
                oldLineString = (LineString)((Feature)iter.next()).getGeometry();
                newLineString = this.mergeLineStrings(oldLineString, newLineString);
                if (i <= 0) continue;
                transaction.setGeometry(transaction.getFeature(i), (Geometry)empty);
            }
            transaction.setGeometry(0, (Geometry)newLineString);
            transaction.commit();
        }
    }
}

