/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractSaveProjectPlugIn
extends AbstractPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(Task task, File file, WorkbenchFrame frame) throws Exception {
        StringWriter stringWriter = new StringWriter();
        try {
            new Java2XML().write((Object)task, "project", (Writer)stringWriter);
        }
        finally {
            stringWriter.flush();
        }
        FileUtil.setContents((String)file.getAbsolutePath(), (String)stringWriter.toString());
        task.setName(GUIUtil.nameWithoutExtension(file));
        task.setProjectFile(file);
        ArrayList ignoredLayers = new ArrayList(this.ignoredLayers(task));
        if (!ignoredLayers.isEmpty()) {
            String warning = I18N.get((String)"ui.plugin.AbstractSaveProjectPlugIn.some-layers-were-not-saved-to-the-task-file") + " ";
            for (int i = 0; i < ignoredLayers.size(); ++i) {
                Layer ignoredLayer = (Layer)ignoredLayers.get(i);
                if (i > 0) {
                    warning = warning + "; ";
                }
                warning = warning + ignoredLayer.getName();
            }
            warning = warning + " (" + I18N.get((String)"ui.plugin.AbstractSaveProjectPlugIn.data-source-is-write-only") + ")";
            frame.warnUser(warning);
        }
    }

    private Collection ignoredLayers(Task task) {
        ArrayList<Layer> ignoredLayers = new ArrayList<Layer>();
        for (Layer layer : task.getLayerManager().getLayers()) {
            if (layer.hasReadableDataSource()) continue;
            ignoredLayers.add(layer);
        }
        return ignoredLayers;
    }
}

