/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.coordsys.Reprojector;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class ChangeCoordinateSystemPlugIn
extends AbstractPlugIn {
    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerManager().getUndoableEditReceiver().reportIrreversibleChange();
        CoordinateSystem destination = (CoordinateSystem)JOptionPane.showInputDialog(context.getWorkbenchFrame(), "Coordinate system for task:", this.getName(), -1, null, new ArrayList(CoordinateSystemRegistry.instance((Blackboard)context.getWorkbenchContext().getBlackboard()).getCoordinateSystems()).toArray(), context.getLayerManager().getCoordinateSystem());
        if (destination == null) {
            return false;
        }
        if (context.getLayerManager().getCoordinateSystem() == destination) {
            return true;
        }
        if (Reprojector.instance().wouldChangeValues(context.getLayerManager().getCoordinateSystem(), destination)) {
            ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
            Iterator i = context.getLayerManager().iterator();
            while (i.hasNext()) {
                Layer layer = (Layer)i.next();
                EditTransaction transaction = new EditTransaction((Collection)layer.getFeatureCollectionWrapper().getFeatures(), this.getName(), layer, this.isRollingBackInvalidEdits(context), false, context.getLayerViewPanel());
                for (int j = 0; j < transaction.size(); ++j) {
                    Reprojector.instance().reproject(transaction.getGeometry(j), context.getLayerManager().getCoordinateSystem(), destination);
                }
                transactions.add(transaction);
            }
            EditTransaction.commit(transactions);
        }
        Iterator i = context.getLayerManager().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            layer.getFeatureCollectionWrapper().getFeatureSchema().setCoordinateSystem(destination);
        }
        context.getLayerManager().setCoordinateSystem(destination);
        if (context.getLayerViewPanel() != null) {
            context.getLayerViewPanel().getViewport().zoomToFullExtent();
        }
        return true;
    }
}

