/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.FUTURE_JTS_WKTWriter;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import com.vividsolutions.jump.workbench.ui.plugin.WKTPlugIn;
import java.util.Arrays;

public class EditSelectedFeaturePlugIn
extends WKTPlugIn {
    private Feature feature;
    private WKTDisplayHelper helper = new WKTDisplayHelper();

    protected Layer layer(PlugInContext context) {
        return (Layer)context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
    }

    public String getName() {
        return I18N.get((String)"ui.plugin.EditSelectedFeaturePlugIn.view-edit-selected-feature");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNFeaturesMustHaveSelectedItemsCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        return this.execute(context, (Feature)context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().iterator().next(), true);
    }

    public boolean execute(PlugInContext context, Feature feature, boolean editable) throws Exception {
        this.feature = feature;
        this.reportNothingToUndoYet(context);
        return super.execute(context);
    }

    protected void apply(String wkt, PlugInContext context) throws Exception {
        if (!this.layer(context).isEditable()) {
            return;
        }
        super.apply(wkt, context);
    }

    protected void apply(FeatureCollection c, PlugInContext context) throws WorkbenchException {
        if (c.size() != 1) {
            throw new WorkbenchException(I18N.get((String)"ui.plugin.EditSelectedFeaturePlugIn.expected-1-feature-but-found") + " " + c.size());
        }
        EditTransaction transaction = new EditTransaction(Arrays.asList(this.feature), this.getName(), this.layer, this.isRollingBackInvalidEdits(context), false, context.getWorkbenchFrame());
        transaction.setGeometry(0, ((Feature)c.iterator().next()).getGeometry());
        transaction.commit();
    }

    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle((this.layer(context).isEditable() ? I18N.get((String)"ui.plugin.EditSelectedFeaturePlugIn.edit") + " " : "") + I18N.get((String)"ui.plugin.EditSelectedFeaturePlugIn.feature") + " " + this.feature.getID() + " " + I18N.get((String)"ui.plugin.EditSelectedFeaturePlugIn.in") + " " + this.layer + (this.layer(context).isEditable() ? "" : " (" + I18N.get((String)"ui.plugin.EditSelectedFeaturePlugIn.layer-is-uneditable") + ")"));
        d.setEditable(this.layer(context).isEditable());
        d.setText(this.helper.format(new FUTURE_JTS_WKTWriter().write(this.feature.getGeometry())));
        return d;
    }
}

