/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.io.FUTURE_JTS_WKTWriter;
import com.vividsolutions.jump.io.GMLGeometryWriter;
import com.vividsolutions.jump.util.Fmt;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AbstractFeatureTextWriter;

public class InstallStandardFeatureTextWritersPlugIn
extends AbstractPlugIn {
    private static final AbstractFeatureTextWriter COORDINATE_WRITER = new AbstractFeatureTextWriter(false, "CL", "Coordinate List"){

        public String write(Feature feature) {
            StringBuffer s = new StringBuffer();
            String className = StringUtil.classNameWithoutQualifiers((String)feature.getGeometry().getClass().getName());
            s.append(className + "\n");
            Coordinate[] coordinates = feature.getGeometry().getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                s.append("[" + Fmt.fmt((int)i, (int)10) + "] ");
                s.append(coordinates[i].x + ", " + coordinates[i].y + "\n");
            }
            return s.toString().trim();
        }
    };
    private static final AbstractFeatureTextWriter GML_WRITER = new AbstractFeatureTextWriter(false, "GML", "Geography Markup Language"){
        private GMLGeometryWriter writer = new GMLGeometryWriter();

        public String write(Feature feature) {
            return this.writer.write(feature.getGeometry());
        }
    };
    private static final AbstractFeatureTextWriter WKT_WRITER = new AbstractFeatureTextWriter(true, "WKT", "Well-Known Text"){
        private FUTURE_JTS_WKTWriter wktWriter = new FUTURE_JTS_WKTWriter();

        public String write(Feature feature) {
            return this.wktWriter.write(feature.getGeometry()).trim();
        }
    };

    public void initialize(PlugInContext context) throws Exception {
        context.getWorkbenchContext().getFeatureTextWriterRegistry().register(WKT_WRITER);
        context.getWorkbenchContext().getFeatureTextWriterRegistry().register(GML_WRITER);
        context.getWorkbenchContext().getFeatureTextWriterRegistry().register(COORDINATE_WRITER);
    }
}

