/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.ExportImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.plugin.file.LayerPrinter2;
import org.openjump.core.ui.plugin.file.WorldFileWriter;

public class SaveImageAsPlugIn
extends ExportImagePlugIn {
    private List myFileFilters = Arrays.asList(this.createFileFilter("PNG - Portable Network Graphics", "png", 2), this.createFileFilter("JPEG - Joint Photographic Experts Group", "jpg", 1));
    private JFileChooser fileChooser = null;
    private WorkbenchContext workbenchContext;
    private JCheckBox worldFileCheckBox = null;
    private JLabel pixelSizeLabel = new JLabel("X");
    private final ImageIcon icon = IconLoader.icon("Box.gif");
    private Geometry fence = null;
    private boolean fenceFound = false;
    private ValidatingTextField pixelSizeField = new ValidatingTextField("9999", 5, new ValidatingTextField.Validator(){

        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                int i = Integer.parseInt(text);
                return i <= 3800;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    });
    private static final String FORMAT_KEY = "FORMAT";
    private static final String LAST_FILENAME_KEY = "LAST FILENAME";

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new GUIUtil.FileChooserWithOverwritePrompting(){

                protected File selectedFile() {
                    return new File(SaveImageAsPlugIn.this.addExtension(super.selectedFile().getPath(), ((MyFileFilter)this.getFileFilter()).getFormat()));
                }
            };
            this.fileChooser.setDialogTitle(I18N.get((String)"ui.plugin.SaveImageAsPlugIn.save-image"));
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            HashMap<String, MyFileFilter> formatToFileFilterMap = new HashMap<String, MyFileFilter>();
            for (MyFileFilter fileFilter : this.myFileFilters) {
                this.fileChooser.addChoosableFileFilter(fileFilter);
                formatToFileFilterMap.put(fileFilter.getFormat(), fileFilter);
            }
            String lastFilename = (String)PersistentBlackboardPlugIn.get(this.workbenchContext).get(LAST_FILENAME_KEY);
            if (lastFilename != null) {
                this.fileChooser.setSelectedFile(new File(lastFilename));
            }
            this.fileChooser.setFileFilter((FileFilter)formatToFileFilterMap.get(PersistentBlackboardPlugIn.get(this.workbenchContext).get(FORMAT_KEY, (Object)"png")));
            JPanel jPanel = new JPanel();
            this.worldFileCheckBox = new JCheckBox();
            this.worldFileCheckBox.setText(I18N.get((String)"ui.plugin.SaveImageAsPlugIn.write-world-file"));
            if (this.fence != null) {
                JLabel fenceIcon = new JLabel(this.icon);
                jPanel.add(fenceIcon);
            }
            jPanel.add(this.pixelSizeLabel);
            jPanel.add(this.pixelSizeField);
            jPanel.add(this.worldFileCheckBox);
            this.fileChooser.add((Component)jPanel, "North");
        }
        return this.fileChooser;
    }

    private int getPixelSize() {
        String text = this.pixelSizeField.getText();
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return 800;
        }
    }

    private MyFileFilter createFileFilter(String description, String format, int bufferedmageType) {
        return new MyFileFilter(description, format);
    }

    public boolean execute(PlugInContext context) throws Exception {
        BufferedImage image;
        this.workbenchContext = context.getWorkbenchContext();
        this.fence = context.getLayerViewPanel().getFence();
        boolean bl = this.fenceFound = this.fence != null;
        if (this.fenceFound) {
            this.pixelSizeField.setText("800");
        } else {
            this.pixelSizeField.setText(context.getLayerViewPanel().getWidth() + "");
        }
        if (0 != this.getFileChooser().showSaveDialog(context.getWorkbenchFrame())) {
            this.fileChooser = null;
            return false;
        }
        MyFileFilter fileFilter = (MyFileFilter)this.getFileChooser().getFileFilter();
        LayerViewPanel viewPanel = context.getLayerViewPanel();
        Envelope envelope = null;
        if (!this.fenceFound && this.getPixelSize() == context.getLayerViewPanel().getWidth()) {
            image = this.image(viewPanel);
        } else {
            LayerPrinter2 layerPrinter = new LayerPrinter2();
            if (this.fenceFound) {
                envelope = this.fence.getEnvelopeInternal();
                Layer fenceLayer = this.workbenchContext.getLayerNamePanel().getLayerManager().getLayer("Fence");
                fenceLayer.setVisible(false);
            } else {
                envelope = this.workbenchContext.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
            }
            image = layerPrinter.print((Collection)this.workbenchContext.getLayerManager().getLayers(), envelope, this.getPixelSize());
            viewPanel = layerPrinter.getLayerViewPanel();
        }
        String filename = this.addExtension(this.getFileChooser().getSelectedFile().getPath(), fileFilter.getFormat());
        File imageFile = new File(filename);
        this.save(image, fileFilter.getFormat(), imageFile);
        PersistentBlackboardPlugIn.get(this.workbenchContext).put(FORMAT_KEY, (Object)fileFilter.getFormat());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put(LAST_FILENAME_KEY, (Object)filename);
        if (this.worldFileCheckBox != null && this.worldFileCheckBox.isSelected()) {
            WorldFileWriter.writeWorldFile((File)imageFile, (LayerViewPanel)viewPanel);
        }
        this.fileChooser = null;
        return true;
    }

    private void save(RenderedImage image, String format, File file) throws IOException {
        boolean writerFound = ImageIO.write(image, format, file);
        Assert.isTrue((boolean)writerFound, (String)(I18N.get((String)"ui.plugin.SaveImageAsPlugIn.cannot-find-writer-for-image-format") + " '" + format + "'"));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            public String check(JComponent component) {
                return !ExportImagePlugIn.java14OrNewer() ? "This feature requires Java 1.4 or newer" : null;
            }
        });
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }

    private static class MyFileFilter
    extends FileFilter {
        private FileFilter fileFilter;
        private String format;

        public MyFileFilter(String description, String format) {
            this.fileFilter = GUIUtil.createFileFilter(description, new String[]{format});
            this.format = format;
        }

        public boolean accept(File f) {
            return this.fileFilter.accept(f);
        }

        public String getDescription() {
            return this.fileFilter.getDescription();
        }

        public String getFormat() {
            return this.format;
        }
    }
}

