/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;

public abstract class WKTPlugIn
extends AbstractPlugIn {
    protected Layer layer;

    private void validate(FeatureCollection c, PlugInContext context) throws WorkbenchException {
        for (Feature f : c) {
            IsValidOp op = new IsValidOp(f.getGeometry());
            if (op.isValid()) continue;
            if (context.getWorkbenchContext().getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                throw new WorkbenchException(op.getValidationError().getMessage());
            }
            context.getWorkbenchFrame().warnUser(op.getValidationError().getMessage());
        }
    }

    protected abstract Layer layer(PlugInContext var1);

    public boolean execute(PlugInContext context) throws Exception {
        this.layer = this.layer(context);
        EnterWKTDialog d = this.createDialog(context);
        d.setVisible(true);
        return d.wasOKPressed();
    }

    protected abstract void apply(FeatureCollection var1, PlugInContext var2) throws WorkbenchException;

    protected EnterWKTDialog createDialog(final PlugInContext context) {
        final EnterWKTDialog d = new EnterWKTDialog(context.getWorkbenchFrame(), I18N.get((String)"ui.plugin.WKTPlugIn.enter-well-known-text"), true);
        d.setSize(500, 400);
        d.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (d.wasOKPressed()) {
                        WKTPlugIn.this.apply(d.getText(), context);
                    }
                    d.setVisible(false);
                }
                catch (Throwable t) {
                    context.getErrorHandler().handleThrowable(t);
                }
            }
        });
        GUIUtil.centreOnWindow(d);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(String wkt, PlugInContext context) throws Exception {
        StringReader stringReader = new StringReader(wkt);
        try {
            WKTReader wktReader = new WKTReader();
            FeatureCollection c = wktReader.read((Reader)stringReader);
            this.validate(c, context);
            this.apply(c, context);
        }
        finally {
            stringReader.close();
        }
    }
}

