/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class ConvexHullPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String LAYER = I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Source-Layer");
    private MultiInputDialog dialog;
    private String categoryName = StandardCategoryNames.RESULT;

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName() + "...", false, null, ConvexHullPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.LAYER = I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Source-Layer");
        this.initDialog(context);
        this.dialog.setVisible(true);
        return this.dialog.wasOKPressed();
    }

    public String getName() {
        return I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Convex-Hull-on-Layer");
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Convex-Hull-on-Layer"), true);
        this.dialog.setSideBarDescription(I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Creates-a-new-layer-containing-the-convex-hull-of-all-the-features-in-the-source-layer"));
        String fieldName = this.LAYER;
        JComboBox addLayerComboBox = this.dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        GUIUtil.centreOnWindow(this.dialog);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollectionWrapper a = this.dialog.getLayer(this.LAYER).getFeatureCollectionWrapper();
        FeatureCollection hullFC = this.convexHhull(monitor, (FeatureCollection)a);
        if (hullFC == null) {
            return;
        }
        context.getLayerManager().addCategory(this.categoryName);
        context.addLayer(this.categoryName, I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Convex-Hull"), hullFC);
    }

    private FeatureCollection convexHhull(TaskMonitor monitor, FeatureCollection fc) {
        monitor.allowCancellationRequests();
        monitor.report(I18N.get((String)"ui.plugin.analysis.ConvexHullPlugIn.Computing-Convex-Hull") + "...");
        int size = fc.size();
        GeometryFactory geomFact = null;
        if (size == 0) {
            return null;
        }
        int count = 0;
        Geometry[] geoms = new Geometry[size];
        for (Feature f : fc) {
            Geometry geom = f.getGeometry();
            if (geom == null) continue;
            if (geomFact == null) {
                geomFact = geom.getFactory();
            }
            geoms[count++] = geom;
        }
        GeometryCollection gc = geomFact.createGeometryCollection(geoms);
        Geometry hull = gc.convexHull();
        ArrayList<Geometry> hullList = new ArrayList<Geometry>();
        hullList.add(hull);
        return FeatureDatasetFactory.createFromGeometry(hullList);
    }
}

