/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.plugin.util.LayerNameGenerator;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryPredicate;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.SpatialQueryExecuter;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SpatialQueryPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String UPDATE_SRC = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Select-features-in-the-source-layer");
    private static String CREATE_LYR = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Create-a-new-layer-for-the-results");
    private static String MASK_LAYER = GenericNames.MASK_LAYER;
    private static String SRC_LAYER = GenericNames.SOURCE_LAYER;
    private static String PREDICATE = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Relation");
    private static String PARAM = GenericNames.PARAMETER;
    private static String DIALOG_COMPLEMENT = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Complement-Result");
    private static String ALLOW_DUPS = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Allow-Duplicates-in-Result");
    private JTextField paramField;
    private Collection functionNames;
    private MultiInputDialog dialog;
    private Layer maskLyr;
    private Layer srcLayer;
    private String funcNameToRun;
    private GeometryPredicate functionToRun = null;
    private boolean complementResult = false;
    private boolean allowDups = false;
    private boolean exceptionThrown = false;
    private JRadioButton updateSourceRB;
    private JRadioButton createNewLayerRB;
    private boolean createLayer = true;
    private double[] params = new double[2];
    private String categoryName = StandardCategoryNames.RESULT;

    public SpatialQueryPlugIn() {
        this.functionNames = GeometryPredicate.getNames();
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    public String getName() {
        return I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Spatial-Query");
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QUERIES}, this.getName() + "...", false, null, SpatialQueryPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(2));
    }

    public boolean execute(PlugInContext context) throws Exception {
        UPDATE_SRC = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Select-features-in-the-source-layer");
        CREATE_LYR = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Create-a-new-layer-for-the-results");
        MASK_LAYER = GenericNames.MASK_LAYER;
        SRC_LAYER = GenericNames.SOURCE_LAYER;
        PREDICATE = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Relation");
        PARAM = GenericNames.PARAMETER;
        DIALOG_COMPLEMENT = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Complement-Result");
        ALLOW_DUPS = I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Allow-Duplicates-in-Result");
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        if (this.functionToRun == null) {
            return;
        }
        if (this.maskLyr == null) {
            return;
        }
        if (this.srcLayer == null) {
            return;
        }
        monitor.report(I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Executing-query") + " " + this.functionToRun.getName() + "...");
        FeatureCollectionWrapper maskFC = this.maskLyr.getFeatureCollectionWrapper();
        FeatureCollectionWrapper sourceFC = this.srcLayer.getFeatureCollectionWrapper();
        int nArgs = this.functionToRun.getGeometryArgumentCount();
        SpatialQueryExecuter executer = new SpatialQueryExecuter((FeatureCollection)maskFC, (FeatureCollection)sourceFC);
        executer.setAllowDuplicates(this.allowDups);
        executer.setComplementResult(this.complementResult);
        executer.setCreateNewLayer(this.createLayer);
        FeatureCollection resultFC = executer.getResultFC();
        executer.execute(monitor, this.functionToRun, this.params, resultFC);
        if (monitor.isCancelRequested()) {
            return;
        }
        if (this.createLayer) {
            String outputLayerName = LayerNameGenerator.generateOperationOnLayerName(this.funcNameToRun, this.srcLayer.getName());
            context.getLayerManager().addCategory(this.categoryName);
            context.addLayer(this.categoryName, outputLayerName, resultFC);
        } else {
            SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
            selectionManager.clear();
            selectionManager.getFeatureSelection().selectItems(this.srcLayer, resultFC.getFeatures());
        }
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser(I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Errors-found-while-executing-query"));
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.Finds-the-Source-features-which-have-a-given-spatial-relationship-to-some-feature-in-the-Mask-layer") + " (" + I18N.get((String)"ui.plugin.analysis.SpatialQueryPlugIn.ie-where-Source.Relationship(Mask)-is-true") + ")");
        Layer initLayer = this.srcLayer == null ? context.getCandidateLayer(0) : this.srcLayer;
        dialog.addLayerComboBox(SRC_LAYER, initLayer, context.getLayerManager());
        JComboBox functionComboBox = dialog.addComboBox(PREDICATE, this.funcNameToRun, this.functionNames, null);
        functionComboBox.addItemListener(new MethodItemListener());
        dialog.addLayerComboBox(MASK_LAYER, this.maskLyr, context.getLayerManager());
        this.paramField = dialog.addDoubleField(PARAM, this.params[0], 10);
        dialog.addCheckBox(ALLOW_DUPS, this.allowDups);
        dialog.addCheckBox(DIALOG_COMPLEMENT, this.complementResult);
        String OUTPUT_GROUP = "OUTPUT_GROUP";
        this.createNewLayerRB = dialog.addRadioButton(CREATE_LYR, "OUTPUT_GROUP", this.createLayer, CREATE_LYR);
        this.updateSourceRB = dialog.addRadioButton(UPDATE_SRC, "OUTPUT_GROUP", !this.createLayer, UPDATE_SRC);
        this.updateUIForFunction(this.funcNameToRun);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.maskLyr = dialog.getLayer(MASK_LAYER);
        this.srcLayer = dialog.getLayer(SRC_LAYER);
        this.funcNameToRun = dialog.getText(PREDICATE);
        this.functionToRun = GeometryPredicate.getPredicate(this.funcNameToRun);
        this.params[0] = dialog.getDouble(PARAM);
        this.allowDups = dialog.getBoolean(ALLOW_DUPS);
        this.complementResult = dialog.getBoolean(DIALOG_COMPLEMENT);
        this.createLayer = dialog.getBoolean(CREATE_LYR);
    }

    private void updateUIForFunction(String funcName) {
        boolean paramUsed = false;
        GeometryPredicate func = GeometryPredicate.getPredicate(funcName);
        if (func != null) {
            paramUsed = func.getParameterCount() > 0;
        }
        this.paramField.setEnabled(paramUsed);
        this.paramField.setOpaque(paramUsed);
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            SpatialQueryPlugIn.this.updateUIForFunction((String)e.getItem());
        }
    }
}

