/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.feature.FeatureUtil;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;

public class UnionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String LAYER = I18N.get((String)"ui.plugin.analysis.UnionPlugIn.layer");
    private String SELECTED_ONLY = I18N.get((String)"ui.plugin.analysis.UnionPlugIn.selected-features-only");
    private boolean useSelected = false;
    private MultiInputDialog dialog;
    private JComboBox addLayerComboBox;

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS, MenuNames.ONELAYER}, this.getName() + "...", false, null, UnionPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        this.useSelected = n > 0;
        this.initDialog(context);
        this.dialog.setVisible(true);
        return this.dialog.wasOKPressed();
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.get((String)"ui.plugin.analysis.UnionPlugIn.union"), true);
        if (this.useSelected) {
            this.dialog.setSideBarDescription(I18N.get((String)"ui.plugin.analysis.UnionPlugIn.creates-a-new-layer-containing-the-union-of-selected-features-in-the-input-layer"));
        } else {
            this.dialog.setSideBarDescription(I18N.get((String)"ui.plugin.analysis.UnionPlugIn.creates-a-new-layer-containing-the-union-of-all-the-features-in-the-input-layer"));
        }
        String fieldName = this.LAYER;
        if (this.useSelected) {
            this.dialog.addLabel(this.SELECTED_ONLY);
        } else {
            this.addLayerComboBox = this.dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        }
        GUIUtil.centreOnWindow(this.dialog);
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollectionWrapper a;
        if (this.useSelected) {
            Collection inputC = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            FeatureSchema featureSchema = new FeatureSchema();
            featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
            a = new FeatureDataset(inputC, featureSchema);
        } else {
            a = this.dialog.getLayer(this.LAYER).getFeatureCollectionWrapper();
        }
        List geoms = FeatureUtil.toGeometries((Collection)a.getFeatures());
        Geometry g = UnaryUnionOp.union((Collection)geoms);
        geoms.clear();
        geoms.add(g);
        FeatureCollection fc = FeatureDatasetFactory.createFromGeometry((Collection)geoms);
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        context.addLayer(StandardCategoryNames.RESULT, I18N.get((String)"ui.plugin.analysis.UnionPlugIn.union"), fc);
    }
}

