/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SRSUtils;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SRSWizardPanel
extends JPanel
implements WizardPanel {
    public static final String SRS_KEY = "SRS";
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private Map dataMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel srsLabel = new JLabel();
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel formatBoxModel = new DefaultComboBoxModel();
    private JComboBox comboBox = new JComboBox();
    private JLabel formatLabel;
    private JComboBox formatBox;

    public SRSWizardPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    public String getInstructions() {
        return I18N.get((String)"ui.plugin.wms.SRSWizardPanel.the-layers-you-chosen-support-more-than-one-coordinate-reference");
    }

    void jbInit() throws Exception {
        this.srsLabel.setText(I18N.get((String)"ui.plugin.wms.SRSWizardPanel.coordinate-reference-system"));
        this.formatLabel = new JLabel(I18N.get((String)"ui.plugin.wms.SRSWizardPanel.image-format"));
        this.formatBox = new JComboBox();
        this.setLayout(this.gridBagLayout1);
        GridBagConstraints gb = new GridBagConstraints();
        gb.anchor = 17;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.srsLabel, gb);
        ++gb.gridx;
        this.add((Component)this.comboBox, gb);
        ++gb.gridy;
        gb.gridx = 0;
        this.add((Component)this.formatLabel, gb);
        ++gb.gridx;
        this.add((Component)this.formatBox, gb);
    }

    public void exitingToRight() {
        int index = this.comboBox.getSelectedIndex();
        String srsCode = (String)this.getCommonSrsList().get(index);
        this.dataMap.put(SRS_KEY, srsCode);
        this.dataMap.put("FORMAT", this.formatBox.getSelectedItem());
    }

    private List getCommonSrsList() {
        return (List)this.dataMap.get("COMMON_SRS_LIST");
    }

    public void enteredFromLeft(Map dataMap) {
        this.dataMap = dataMap;
        for (String srs : this.getCommonSrsList()) {
            String srsName = SRSUtils.getName(srs);
            this.comboBoxModel.addElement(srsName);
        }
        this.comboBox.setModel(this.comboBoxModel);
        String[] formats = (String[])dataMap.get("FORMAT_LIST");
        this.formatBoxModel.removeAllElements();
        for (String f : formats) {
            this.formatBoxModel.addElement(f);
        }
        this.formatBox.setModel(this.formatBoxModel);
    }

    public String getTitle() {
        return I18N.get((String)"ui.plugin.wms.SRSWizardPanel.select-coordinate-reference-system");
    }

    public String getID() {
        return this.getClass().getName();
    }

    public boolean isInputValid() {
        return true;
    }

    public String getNextID() {
        return null;
    }
}

