/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import java.util.ArrayList;
import java.util.LinkedList;

public class ThreadQueue {
    public static final long WORKER_STAY_ALIVE_TIME = 5000L;
    protected int[] runningThreads = new int[1];
    protected int maxRunningThreads;
    protected int waitingThreads;
    protected LinkedList queuedRunnables;
    protected boolean disposed;
    protected ArrayList listeners = new ArrayList();

    public ThreadQueue() {
        this(1);
    }

    public ThreadQueue(int maxRunningThreads) {
        this.maxRunningThreads = Math.max(1, maxRunningThreads);
        this.queuedRunnables = new LinkedList();
    }

    public synchronized void add(Listener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized void remove(Listener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAllRunningThreadsFinished() {
        ArrayList copy;
        ThreadQueue threadQueue = this;
        synchronized (threadQueue) {
            copy = new ArrayList(this.listeners);
        }
        for (int i = copy.size() - 1; i >= 0; --i) {
            ((Listener)copy.get(i)).allRunningThreadsFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runningThreads() {
        int[] nArray = this.runningThreads;
        synchronized (this.runningThreads) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.runningThreads[0];
        }
    }

    public int getRunningThreads() {
        return this.runningThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitingRunnables() {
        int[] nArray = this.runningThreads;
        synchronized (this.runningThreads) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.queuedRunnables.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitingThreads() {
        LinkedList linkedList = this.queuedRunnables;
        synchronized (linkedList) {
            return this.waitingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable runnable) {
        Object object = this.queuedRunnables;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            int waiting = this.waitingThreads;
            this.queuedRunnables.add(runnable);
            this.queuedRunnables.notify();
        }
        object = this.runningThreads;
        synchronized (this.runningThreads) {
            if (this.waitingThreads < 2 && this.runningThreads[0] < this.maxRunningThreads) {
                this.runningThreads[0] = this.runningThreads[0] + 1;
                Worker w = new Worker();
                w.setDaemon(true);
                w.start();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.queuedRunnables;
        synchronized (linkedList) {
            this.queuedRunnables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.queuedRunnables;
        synchronized (object) {
            this.disposed = true;
            this.queuedRunnables.clear();
            this.queuedRunnables.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    public static interface Listener {
        public void allRunningThreadsFinished();
    }

    protected class Worker
    extends Thread {
        protected Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    LinkedList linkedList = ThreadQueue.this.queuedRunnables;
                    // MONITORENTER : linkedList
                    if (ThreadQueue.this.queuedRunnables.isEmpty()) {
                        ++ThreadQueue.this.waitingThreads;
                        try {
                            ThreadQueue.this.queuedRunnables.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            --ThreadQueue.this.waitingThreads;
                        }
                        if (ThreadQueue.this.queuedRunnables.isEmpty()) {
                            // MONITOREXIT : linkedList
                            break;
                        }
                    }
                    if (ThreadQueue.this.disposed) {
                        // MONITOREXIT : linkedList
                        break;
                    }
                    Runnable runnable = (Runnable)ThreadQueue.this.queuedRunnables.remove();
                    // MONITOREXIT : linkedList
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    int[] nArray = ThreadQueue.this.runningThreads;
                    // MONITORENTER : ThreadQueue.this.runningThreads
                    boolean lastRunningThread = ThreadQueue.this.runningThreads[0] == 1;
                    // MONITOREXIT : nArray
                    if (!lastRunningThread) continue;
                    ThreadQueue.this.fireAllRunningThreadsFinished();
                }
                int[] nArray = ThreadQueue.this.runningThreads;
            }
            catch (Throwable throwable) {
                int[] nArray = ThreadQueue.this.runningThreads;
                // MONITORENTER : ThreadQueue.this.runningThreads
                ThreadQueue.this.runningThreads[0] = ThreadQueue.this.runningThreads[0] - 1;
                // MONITOREXIT : nArray
                throw throwable;
            }
            ThreadQueue.this.runningThreads[0] = ThreadQueue.this.runningThreads[0] - 1;
            // MONITOREXIT : nArray
        }
    }
}

