/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.ShapeCollectionPathIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

public class PolygonShape
implements Shape {
    private GeneralPath shell;
    private ArrayList holes = new ArrayList();

    public PolygonShape() {
        this.shell = null;
        this.holes = null;
    }

    public PolygonShape(Coordinate[] shellVertices, Collection holeVerticesCollection) {
        this.shell = this.toPolygon(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            this.holes.add(this.toPolygon(holeVertices));
        }
    }

    public final GeneralPath toPolygon(Coordinate[] coordinates) {
        int numPoints = coordinates.length;
        GeneralPath shape = new GeneralPath(0, numPoints);
        PolygonPath pi = new PolygonPath(coordinates);
        shape.append(pi, false);
        return shape;
    }

    public Rectangle getBounds() {
        return this.shell.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.shell.getBounds2D();
    }

    public boolean contains(double x, double y) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean contains(Point2D p) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean intersects(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method intersects() not yet implemented.");
    }

    public boolean intersects(Rectangle2D r) {
        throw new UnsupportedOperationException("Method intersects() not yet implemented.");
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean contains(Rectangle2D r) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public PathIterator getPathIterator(AffineTransform at) {
        ArrayList<GeneralPath> rings = new ArrayList<GeneralPath>();
        rings.add(this.shell);
        rings.addAll(this.holes);
        return new ShapeCollectionPathIterator(rings, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class PolygonPath
    implements PathIterator {
        private int iterate;
        private int numPoints;
        private Coordinate[] points;

        public PolygonPath(Coordinate[] coordinates) {
            this.points = coordinates;
            this.numPoints = this.points.length;
            this.iterate = 0;
        }

        private int getSegType() {
            if (this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.points[this.iterate].x;
            coords[1] = this.points[this.iterate].y;
            return this.getSegType();
        }

        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[this.iterate].x;
            coords[1] = (float)this.points[this.iterate].y;
            return this.getSegType();
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        public void next() {
            ++this.iterate;
        }
    }
}

