/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineStringEndpointStyle;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public abstract class CircleLineStringEndpointStyle
extends LineStringEndpointStyle {
    private static final int DIAMETER = 8;
    private Stroke circleStroke = new BasicStroke(2.0f);

    private CircleLineStringEndpointStyle(String name, boolean start, String iconFile) {
        super(name, IconLoader.icon(iconFile), start);
    }

    protected void paint(Point2D terminal, Point2D next, Viewport viewport, Graphics2D graphics) throws NoninvertibleTransformException {
        graphics.setColor(this.lineColorWithAlpha);
        graphics.setStroke(this.circleStroke);
        graphics.draw(this.toShape(terminal));
    }

    private Shape toShape(Point2D viewPoint) {
        return new Ellipse2D.Double(viewPoint.getX() - 4.0, viewPoint.getY() - 4.0, 8.0, 8.0);
    }

    public static class End
    extends CircleLineStringEndpointStyle {
        public End() {
            super(I18N.get((String)"ui.renderer.style.CircleLineStringEndpointStyle.End-Circle"), false, "CircleEnd.gif");
        }
    }

    public static class Start
    extends CircleLineStringEndpointStyle {
        public Start() {
            super(I18N.get((String)"ui.renderer.style.CircleLineStringEndpointStyle.Start-Circle"), true, "CircleStart.gif");
        }
    }
}

