/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;

public class ColorThemingStyle
implements Style {
    private BasicStyle defaultStyle;
    private Layer layer;
    private Map attributeValueToBasicStyleMap = new HashMap();
    private Map attributeValueToLabelMap;
    private String attributeName;
    private boolean enabled = false;

    public ColorThemingStyle() {
    }

    public void setAlpha(int alpha) {
        this.defaultStyle.setAlpha(alpha);
        for (BasicStyle style : this.attributeValueToBasicStyleMap.values()) {
            style.setAlpha(alpha);
        }
    }

    public void setLineWidth(int lineWidth) {
        this.defaultStyle.setLineWidth(lineWidth);
        for (BasicStyle style : this.attributeValueToBasicStyleMap.values()) {
            style.setLineWidth(lineWidth);
        }
    }

    public ColorThemingStyle(String attributeName, Map attributeValueToBasicStyleMap, BasicStyle defaultStyle) {
        this(attributeName, attributeValueToBasicStyleMap, ColorThemingStyle.attributeValueToLabelMap(attributeValueToBasicStyleMap), defaultStyle);
    }

    public ColorThemingStyle(String attributeName, Map attributeValueToBasicStyleMap, Map attributeValueToLabelMap, BasicStyle defaultStyle) {
        this.setAttributeName(attributeName);
        this.setAttributeValueToBasicStyleMap(attributeValueToBasicStyleMap);
        this.setAttributeValueToLabelMap(attributeValueToLabelMap);
        this.setDefaultStyle(defaultStyle);
    }

    private static Map attributeValueToLabelMap(Map attributeValueToBasicStyleMap) {
        Map attributeValueToLabelMap = (Map)LangUtil.newInstance(attributeValueToBasicStyleMap.getClass());
        for (Object value : attributeValueToBasicStyleMap.keySet()) {
            attributeValueToLabelMap.put(value, value.toString());
        }
        return attributeValueToLabelMap;
    }

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        this.getStyle(f).paint(f, g, viewport);
    }

    private BasicStyle getStyle(Feature feature) {
        BasicStyle style = null;
        try {
            style = this.attributeName != null && feature.getSchema().hasAttribute(this.attributeName) && feature.getAttribute(this.attributeName) != null ? (BasicStyle)this.attributeValueToBasicStyleMap.get(ColorThemingStyle.trimIfString(feature.getAttribute(this.attributeName))) : this.defaultStyle;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return style == null ? this.defaultStyle : style;
    }

    public static Object trimIfString(Object object) {
        return object != null && object instanceof String ? ((String)object).trim() : object;
    }

    public Object clone() {
        try {
            ColorThemingStyle clone = (ColorThemingStyle)super.clone();
            clone.attributeValueToBasicStyleMap = (Map)this.attributeValueToBasicStyleMap.getClass().newInstance();
            for (Object attribute : this.attributeValueToBasicStyleMap.keySet()) {
                clone.attributeValueToBasicStyleMap.put(attribute, ((BasicStyle)this.attributeValueToBasicStyleMap.get(attribute)).clone());
            }
            clone.attributeValueToLabelMap = (Map)this.attributeValueToLabelMap.getClass().newInstance();
            clone.attributeValueToLabelMap.putAll(this.attributeValueToLabelMap);
            return clone;
        }
        catch (InstantiationException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
        catch (IllegalAccessException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeValueToBasicStyleMap(Map attributeValueToBasicStyleMap) {
        this.attributeValueToBasicStyleMap = attributeValueToBasicStyleMap;
    }

    public void setAttributeValueToLabelMap(Map attributeValueToLabelMap) {
        this.attributeValueToLabelMap = attributeValueToLabelMap;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Map getAttributeValueToBasicStyleMap() {
        return this.attributeValueToBasicStyleMap;
    }

    public Map getAttributeValueToLabelMap() {
        return this.attributeValueToLabelMap;
    }

    public void initialize(Layer layer) {
        this.layer = layer;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static ColorThemingStyle get(Layer layer) {
        if ((ColorThemingStyle)layer.getStyle(ColorThemingStyle.class) == null) {
            ColorThemingStyle colorThemingStyle = new ColorThemingStyle(ColorThemingStyle.pickNonSpatialAttributeName(layer.getFeatureCollectionWrapper().getFeatureSchema()), new HashMap(), new BasicStyle(Color.lightGray));
            layer.addStyle(colorThemingStyle);
        }
        return (ColorThemingStyle)layer.getStyle(ColorThemingStyle.class);
    }

    private static String pickNonSpatialAttributeName(FeatureSchema schema) {
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getGeometryIndex() == i) continue;
            return schema.getAttributeName(i);
        }
        return null;
    }

    public BasicStyle getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(BasicStyle defaultStyle) {
        this.defaultStyle = defaultStyle;
    }
}

