/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import com.vividsolutions.jump.workbench.ui.snap.VisiblePointsAndLinesCache;

public class SnapToFeaturesPolicy
implements SnapPolicy {
    private Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToFeaturesPolicy.class.getName() + " - ENABLED";
    private InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private GeometryFactory factory = new GeometryFactory();

    public SnapToFeaturesPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    public SnapToFeaturesPolicy() {
        this(new Blackboard());
        this.blackboard.put(ENABLED_KEY, true);
    }

    public Coordinate snap(LayerViewPanel panel, Coordinate originalCoordinate) {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return null;
        }
        Geometry bufferedTransformedCursorLocation = this.factory.createPoint(originalCoordinate).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        for (Geometry candidate : VisiblePointsAndLinesCache.instance(panel).getTree().query(bufferedTransformedCursorLocation.getEnvelopeInternal())) {
            if (!(candidate instanceof GeometryCollection)) {
                Geometry intersection = candidate.intersection(bufferedTransformedCursorLocation);
                if (intersection.isEmpty()) continue;
                return this.interiorPointFinder.findPoint(intersection);
            }
            GeometryCollection col = (GeometryCollection)candidate;
            for (int k = 0; k < col.getNumGeometries(); ++k) {
                Geometry intersection = col.getGeometryN(k).intersection(bufferedTransformedCursorLocation);
                if (intersection.isEmpty()) continue;
                return this.interiorPointFinder.findPoint(intersection);
            }
        }
        return null;
    }
}

