/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPlugIn;
import com.vividsolutions.jump.workbench.ui.warp.DeleteIncrementalWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.DeleteWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.DrawIncrementalWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.DrawWarpingVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.WarpingPanel;
import java.awt.Component;
import javax.swing.JComponent;

public class WarpingPlugIn
extends ToolboxPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        this.createMainMenuItem(new String[]{MenuNames.TOOLS, MenuNames.TOOLS_WARP}, GUIUtil.toSmallIcon(IconLoader.icon("GoalFlag.gif")), context.getWorkbenchContext());
    }

    protected void initializeToolbox(ToolboxDialog toolbox) {
        WarpingPanel warpingPanel = new WarpingPanel(toolbox);
        toolbox.getCenterPanel().add((Component)warpingPanel, "Center");
        this.add(new DrawWarpingVectorTool(), false, toolbox, warpingPanel);
        this.add(new DeleteWarpingVectorTool(), false, toolbox, warpingPanel);
        toolbox.getToolBar().addSeparator();
        this.add(new DrawIncrementalWarpingVectorTool(warpingPanel), true, toolbox, warpingPanel);
        this.add(new DeleteIncrementalWarpingVectorTool(warpingPanel), true, toolbox, warpingPanel);
        toolbox.setInitialLocation(new GUIUtil.Location(20, true, 175, false));
    }

    private void add(CursorTool tool, final boolean incremental, ToolboxDialog toolbox, final WarpingPanel warpingPanel) {
        toolbox.add(tool, new EnableCheck(){

            public String check(JComponent component) {
                if (incremental && warpingPanel.isWarpingIncrementally()) {
                    return null;
                }
                if (!incremental && !warpingPanel.isWarpingIncrementally()) {
                    return null;
                }
                return I18N.get((String)"ui.warp.WarpingPlugIn.incremental-warping-must-be") + " " + (incremental ? I18N.get((String)"ui.warp.WarpingPlugIn.enabled") : I18N.get((String)"ui.warp.WarpingPlugIn.disabled"));
            }
        });
    }
}

