/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public abstract class AbstractZoomTool
extends DragTool {
    static final double WHEEL_ZOOM_IN_FACTOR = 1.25;
    static final int BOX_TOLERANCE = 4;
    static final double ZOOM_IN_FACTOR = 2.0;
    protected Image origImage;
    protected Image auxImage = null;
    private boolean isAnimatingZoom = false;

    public boolean setAnimatingZoom(boolean animating) {
        boolean previousValue = this.isAnimatingZoom;
        this.isAnimatingZoom = animating;
        return previousValue;
    }

    public boolean getAnimatingZoom() {
        return this.isAnimatingZoom;
    }

    public Icon getIcon() {
        return IconLoader.icon("Magnify.gif");
    }

    public Cursor getCursor() {
        return AbstractZoomTool.createCursor(IconLoader.icon("MagnifyCursor.gif").getImage());
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int nclicks = e.getWheelRotation();
        try {
            double zoomFactor = nclicks > 0 ? 1.0 / ((double)Math.abs(nclicks) * 1.25) : (double)Math.abs(nclicks) * 1.25;
            this.zoomAt(e.getPoint(), zoomFactor, false);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public Image createImageIfNeeded(Image currImage) {
        if (currImage == null || currImage.getHeight(null) != this.getPanel().getHeight() || currImage.getWidth(null) != this.getPanel().getWidth()) {
            Graphics2D g = (Graphics2D)this.getPanel().getGraphics();
            BufferedImage img = g.getDeviceConfiguration().createCompatibleImage(this.getPanel().getWidth(), this.getPanel().getHeight(), 1);
            return img;
        }
        return currImage;
    }

    public void cacheImage() {
        this.origImage = this.createImageIfNeeded(this.origImage);
        this.getPanel().paint(this.origImage.getGraphics());
    }

    protected void zoomAt(Point2D p, double zoomFactor, boolean animatingZoom) throws NoninvertibleTransformException {
        Viewport vp = this.getPanel().getViewport();
        Point2D zoomPoint = vp.toModelPoint(p);
        Envelope modelEnvelope = vp.getEnvelopeInModelCoordinates();
        Coordinate centre = modelEnvelope.centre();
        double width = modelEnvelope.getWidth();
        double height = modelEnvelope.getHeight();
        double dx = (zoomPoint.getX() - centre.x) / zoomFactor;
        double dy = (zoomPoint.getY() - centre.y) / zoomFactor;
        Envelope zoomModelEnvelope = new Envelope(zoomPoint.getX() - 0.5 * (width / zoomFactor) - dx, zoomPoint.getX() + 0.5 * (width / zoomFactor) - dx, zoomPoint.getY() - 0.5 * (height / zoomFactor) - dy, zoomPoint.getY() + 0.5 * (height / zoomFactor) - dy);
        vp.zoom(zoomModelEnvelope);
    }
}

