/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;

public class PostgisSQLBuilder {
    private SpatialReferenceSystemID defaultSRID = null;
    private String[] colNames = null;

    public PostgisSQLBuilder(SpatialReferenceSystemID defaultSRID, String[] colNames) {
        this.defaultSRID = defaultSRID;
        this.colNames = colNames;
    }

    public String getSQL(FilterQuery query) {
        return this.buildQueryString(query);
    }

    private String buildQueryString(FilterQuery query) {
        StringBuffer qs = new StringBuffer();
        qs.append("SELECT ");
        qs.append(this.getColumnListSpecifier(this.colNames, query.getGeometryAttributeName()));
        qs.append(" FROM ");
        qs.append(query.getDatasetName());
        qs.append(" t WHERE ");
        qs.append(this.buildBoxFilter(query.getGeometryAttributeName(), query.getSRSName(), query.getFilterGeometry()));
        String whereCond = query.getCondition();
        if (whereCond != null) {
            qs.append(" AND ");
            qs.append(whereCond);
        }
        return qs.toString();
    }

    private String buildBoxFilter(String geometryColName, SpatialReferenceSystemID SRID, Geometry geom) {
        Envelope env = geom.getEnvelopeInternal();
        StringBuffer buf = new StringBuffer();
        buf.append(geometryColName + " && SetSRID('BOX3D(");
        buf.append(env.getMinX() + " " + env.getMinY() + "," + env.getMaxX() + " " + env.getMaxY());
        buf.append(")'::box3d,");
        buf.append(this.getSRID(SRID) + ")");
        return buf.toString();
    }

    private String getSRID(SpatialReferenceSystemID querySRID) {
        SpatialReferenceSystemID srid = this.defaultSRID;
        if (!querySRID.isNull()) {
            srid = querySRID;
        }
        if (srid.isNull()) {
            return "NULL";
        }
        return srid.getString();
    }

    private String getColumnListSpecifier(String[] colName, String geomColName) {
        StringBuffer buf = new StringBuffer();
        buf.append("AsBinary(\"").append(geomColName).append("\") as ").append(geomColName);
        for (int i = 0; i < colName.length; ++i) {
            if (geomColName.equalsIgnoreCase(colName[i])) continue;
            buf.append(",\"");
            buf.append(colName[i]).append("\"");
        }
        return buf.toString();
    }
}

