/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jump.geom.LineSegmentEnvelopeIntersector;
import com.vividsolutions.jump.geom.MicroscopePointAdjuster;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeometryMicroscope {
    private List geomList;
    private Envelope env;
    private double minSep;

    public GeometryMicroscope(List geomList, Envelope env, double minSep) {
        this.geomList = geomList;
        this.env = env;
        this.minSep = minSep;
    }

    public List getAdjusted() {
        List segList = this.getSegList();
        MicroscopePointAdjuster mpa = new MicroscopePointAdjuster(segList, this.env, this.minSep);
        Map ptMap = mpa.getAdjustedPointMap();
        this.applyAdjustment(ptMap);
        return this.geomList;
    }

    private void applyAdjustment(Map ptMap) {
        CoordinateAdjusterFilter coordAdjFilter = new CoordinateAdjusterFilter(ptMap);
        for (Geometry geom : this.geomList) {
            geom.apply((CoordinateFilter)coordAdjFilter);
        }
    }

    private List getSegList() {
        ArrayList segList = new ArrayList();
        for (Geometry geom : this.geomList) {
            List coordArrayList = CoordinateArrays.toCoordinateArrays(geom, false);
            this.addSegments(coordArrayList, segList);
        }
        return segList;
    }

    private void addSegments(List coordArrayList, List segList) {
        LineSegmentEnvelopeIntersector linesegEnvInt = new LineSegmentEnvelopeIntersector();
        for (Coordinate[] coord : coordArrayList) {
            for (int j = 0; j < coord.length - 1; ++j) {
                LineSegment seg = new LineSegment(coord[j], coord[j + 1]);
                if (!linesegEnvInt.touches(seg, this.env)) continue;
                segList.add(seg);
            }
        }
    }

    public class CoordinateAdjusterFilter
    implements CoordinateFilter {
        Map ptMap;

        CoordinateAdjusterFilter(Map ptMap) {
            this.ptMap = ptMap;
        }

        public void filter(Coordinate p) {
            Coordinate adj = (Coordinate)this.ptMap.get(p);
            if (adj != null) {
                p.x = adj.x;
                p.y = adj.y;
            }
        }
    }
}

