/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.geom.LineSegmentUtil;
import com.vividsolutions.jump.plugin.edit.SegmentsExtracter;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class ExtractSegmentsPlugIn
extends ThreadedBasePlugIn {
    private MultiInputDialog dialog;
    private String layerName;
    private boolean uniqueSegmentsOnly;
    private boolean mergeResultingSegments;
    private int inputEdgeCount = 0;
    private int uniqueSegmentCount = 0;
    private static final String LAYER = I18N.get("ui.MenuNames.LAYER");

    private static Collection toLineStrings(Collection segments) {
        GeometryFactory fact = new GeometryFactory();
        ArrayList<LineString> lineStringList = new ArrayList<LineString>();
        for (LineSegment seg : segments) {
            LineString ls = LineSegmentUtil.asGeometry(fact, seg);
            lineStringList.add(ls);
        }
        return lineStringList;
    }

    private static Collection toMergedLineStrings(Collection segments) {
        GeometryFactory fact = new GeometryFactory();
        LineMerger lineMerger = new LineMerger();
        for (LineSegment seg : segments) {
            lineMerger.add((Geometry)LineSegmentUtil.asGeometry(fact, seg));
        }
        return lineMerger.getMergedLineStrings();
    }

    public String getName() {
        return I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Extract-Segments");
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, MenuNames.CONVERT}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection linestringList;
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Extracting-Segments"));
        Layer layer = this.dialog.getLayer(LAYER);
        FeatureCollectionWrapper lineFC = layer.getFeatureCollectionWrapper();
        this.inputEdgeCount = lineFC.size();
        SegmentsExtracter extracter = new SegmentsExtracter(monitor);
        extracter.add(lineFC);
        Collection uniqueFSList = this.uniqueSegmentsOnly ? extracter.getSegments(1, 1) : extracter.getSegments();
        this.uniqueSegmentCount = uniqueFSList.size();
        Collection collection = linestringList = this.mergeResultingSegments ? ExtractSegmentsPlugIn.toMergedLineStrings(uniqueFSList) : ExtractSegmentsPlugIn.toLineStrings(uniqueFSList);
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayers(context, linestringList);
    }

    private void createLayers(PlugInContext context, Collection linestringList) throws Exception {
        FeatureCollection lineStringFC = FeatureDatasetFactory.createFromGeometry(linestringList);
        context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Extracted-Segs"), lineStringFC);
        this.createOutput(context);
    }

    private void createOutput(PlugInContext context) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Extract-Segments"));
        context.getOutputFrame().addField(I18N.get("ui.MenuNames.LAYER") + ":", this.layerName);
        context.getOutputFrame().addText(" ");
        context.getOutputFrame().addField(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Number-of-unique-segments-extracted"), "" + this.uniqueSegmentCount);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("ExtractSegments.png")));
        dialog.setSideBarDescription(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Extracts-all-unique-line-segments-from-a-dataset"));
        JComboBox layerComboBox = dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        JCheckBox oneTimeCheckBox = dialog.addCheckBox(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Remove-doubled-segments"), false);
        JCheckBox mergeCheckBox = dialog.addCheckBox(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Merge-resulting-segments"), false);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(LAYER);
        this.layerName = layer.getName();
        this.uniqueSegmentsOnly = dialog.getBoolean(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Remove-doubled-segments"));
        this.mergeResultingSegments = dialog.getBoolean(I18N.get("jump.plugin.edit.ExtractSegmentsPlugIn.Merge-resulting-segments"));
    }
}

