/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class LineNoderPlugIn
extends ThreadedBasePlugIn {
    private boolean useSelected = false;
    private MultiInputDialog dialog;
    private String layerName;
    private GeometryFactory fact = new GeometryFactory();
    private static final String SRC_LAYER = I18N.get("jump.plugin.edit.LineNoderPlugIn.Line-Layer");
    private static final String SELECTED_ONLY = GenericNames.USE_SELECTED_FEATURES_ONLY;

    public String getName() {
        return I18N.get("jump.plugin.edit.LineNoderPlugIn.Node-Lines");
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        Polygonizer polygonizer = new Polygonizer();
        monitor.report(I18N.get("jump.plugin.edit.LineNoderPlugIn.Noding"));
        Layer layer = this.dialog.getLayer(SRC_LAYER);
        Collection inputFeatures = this.getFeaturesToProcess(layer, context);
        Collection lines = this.getLines(inputFeatures);
        monitor.report(I18N.get("jump.plugin.edit.LineNoderPlugIn.Noding-input-lines"));
        Geometry nodedGeom = this.nodeLines((List)lines);
        List nodedLines = LineNoderPlugIn.toLines(nodedGeom);
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayer(context, nodedLines);
    }

    private Collection getFeaturesToProcess(Layer lyr, PlugInContext context) {
        if (this.useSelected) {
            return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        }
        return lyr.getFeatureCollectionWrapper().getFeatures();
    }

    private Collection getLines(Collection inputFeatures) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        for (Feature f : inputFeatures) {
            Geometry g = f.getGeometry();
            g.apply((GeometryComponentFilter)lineFilter);
        }
        return linesList;
    }

    private Geometry nodeLines(Collection lines) {
        MultiLineString linesGeom = this.fact.createMultiLineString(GeometryFactory.toLineStringArray((Collection)lines));
        MultiLineString unionInput = this.fact.createMultiLineString(null);
        Geometry minLine = this.extractPoint(lines);
        if (minLine != null) {
            unionInput = minLine;
        }
        Geometry noded = linesGeom.union((Geometry)unionInput);
        return noded;
    }

    private static List toLines(Geometry geom) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        geom.apply((GeometryComponentFilter)lineFilter);
        return linesList;
    }

    private Geometry extractPoint(Collection lines) {
        int minPts = Integer.MAX_VALUE;
        Point point = null;
        for (Geometry g : lines) {
            if (g.isEmpty()) continue;
            Coordinate p = g.getCoordinate();
            point = g.getFactory().createPoint(p);
        }
        return point;
    }

    private void createLayer(PlugInContext context, Collection nodedLines) throws Exception {
        FeatureCollection polyFC = FeatureDatasetFactory.createFromGeometry(nodedLines);
        context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + I18N.get("jump.plugin.edit.LineNoderPlugIn.Noded-Lines"), polyFC);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("Polygonize.png")));
        dialog.setSideBarDescription(I18N.get("jump.plugin.edit.LineNoderPlugIn.Nodes-the-lines-in-a-layer"));
        String fieldName = SRC_LAYER;
        JComboBox addLayerComboBox = dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(SELECTED_ONLY, this.useSelected);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(SRC_LAYER);
        this.layerName = layer.getName();
        this.useSelected = dialog.getBoolean(SELECTED_ONLY);
    }
}

