/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.geom.precision.GeometryPrecisionReducer;
import com.vividsolutions.jump.geom.precision.NumberPrecisionReducer;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.ColorUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleUtil;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PrecisionReducerPlugIn
extends ThreadedBasePlugIn {
    private static final double EXAMPLE_VALUE = 1234567.123123123;
    private static final String LAYER = I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Layer");
    private static final String DECIMAL_PLACES = I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Decimal-Places");
    private static final String SCALE_FACTOR = I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Scale-Factor");
    private MultiInputDialog dialog;
    private JTextField decimalPlacesField;
    private JTextField scaleFactorField;
    private JLabel exampleLabel;
    private String layerName;
    private int decimalPlaces = 0;
    private int scaleFactor = 1;

    public String getName() {
        return I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Precision-Reducer");
    }

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem((PlugIn)this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1));
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow((Component)this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Reducing-Precision") + "...");
        Layer layer = this.dialog.getLayer(LAYER);
        FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
        List[] bad = this.reducePrecision(fc, monitor);
        layer.fireAppearanceChanged();
        if (monitor.isCancelRequested()) {
            return;
        }
        if (bad[0].size() > 0) {
            Layer lyr = context.getLayerManager().addLayer(StandardCategoryNames.QA, I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Invalid-Input-Geometries"), FeatureDatasetFactory.createFromGeometry(bad[0]));
            LayerStyleUtil.setLinearStyle((Layer)lyr, (Color)Color.red, (int)2, (int)0);
            lyr.fireAppearanceChanged();
            Layer lyr2 = context.getLayerManager().addLayer(StandardCategoryNames.QA, I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Invalid-Reduced-Geometries"), FeatureDatasetFactory.createFromGeometry(bad[1]));
            lyr2.getBasicStyle().setFillColor(ColorUtil.GOLD);
            lyr2.getBasicStyle().setLineColor(Layer.defaultLineColor((Color)ColorUtil.GOLD));
            lyr2.fireAppearanceChanged();
        }
    }

    private NumberPrecisionReducer createNumberPrecisionReducer() {
        double sf = this.scaleFactor;
        if ((double)this.scaleFactor != NumberPrecisionReducer.scaleFactorForDecimalPlaces(this.decimalPlaces)) {
            sf = NumberPrecisionReducer.scaleFactorForDecimalPlaces(this.decimalPlaces);
        }
        return new NumberPrecisionReducer(sf);
    }

    private List[] reducePrecision(FeatureCollection fc, TaskMonitor monitor) {
        List[] bad = new List[]{new ArrayList(), new ArrayList()};
        int total = fc.size();
        int count = 0;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            monitor.report(count++, total, I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.features"));
            Feature f = (Feature)i.next();
            Geometry g = f.getGeometry();
            Geometry g2 = (Geometry)g.clone();
            GeometryPrecisionReducer pr = new GeometryPrecisionReducer(this.createNumberPrecisionReducer());
            pr.reduce(g2);
            if (g2.isValid()) {
                f.setGeometry(g2);
                continue;
            }
            bad[0].add(g.clone());
            bad[1].add(g2);
        }
        return bad;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("PrecisionReducer.png")));
        dialog.setSideBarDescription(I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Reduces-the-precision-of-the-coordinates-in-a-layer"));
        String fieldName = LAYER;
        JComboBox addLayerComboBox = dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        this.scaleFactorField = dialog.addIntegerField(SCALE_FACTOR, this.scaleFactor, 8, I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.The-scale-factor-to-multiply-by-before-rounding-(-Negative-for-left-of-decimal-point-,-0-if-not-used-)"));
        this.scaleFactorField.getDocument().addDocumentListener(new ScaleFactorDocumentListener());
        this.decimalPlacesField = dialog.addIntegerField(DECIMAL_PLACES, this.decimalPlaces, 4, I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.The-number-of-decimal-places-to-round-to-(-Negative-for-left-of-decimal-point-)"));
        this.decimalPlacesField.getDocument().addDocumentListener(new DecimalPlacesDocumentListener());
        dialog.addLabel("");
        dialog.addLabel(I18N.get("ui.plugin.edit.PrecisionReducerPlugIn.Example") + "  " + 1234567.123123123);
        this.exampleLabel = dialog.addLabel("");
        this.updateExample();
    }

    private int parseValidInt(String text) {
        int i = 0;
        try {
            i = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    private void decimalPlacesChanged() {
        this.decimalPlaces = this.parseValidInt(this.decimalPlacesField.getText());
        double sf = NumberPrecisionReducer.scaleFactorForDecimalPlaces(this.decimalPlaces);
        this.scaleFactorField.setText("" + (int)sf);
        this.updateExample();
    }

    private void scaleFactorChanged() {
        this.scaleFactor = this.parseValidInt(this.scaleFactorField.getText());
        this.updateExample();
    }

    private void updateExample() {
        NumberPrecisionReducer cpr = new NumberPrecisionReducer(this.scaleFactor);
        double exampleOutput = cpr.reducePrecision(1234567.123123123);
        this.exampleLabel.setText("      ==>  " + exampleOutput);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(LAYER);
        this.layerName = layer.getName();
        this.decimalPlaces = dialog.getInteger(DECIMAL_PLACES);
        this.scaleFactor = dialog.getInteger(SCALE_FACTOR);
    }

    class ScaleFactorDocumentListener
    implements DocumentListener {
        ScaleFactorDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.scaleFactorChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.scaleFactorChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.scaleFactorChanged();
        }
    }

    class DecimalPlacesDocumentListener
    implements DocumentListener {
        DecimalPlacesDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.decimalPlacesChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.decimalPlacesChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            PrecisionReducerPlugIn.this.decimalPlacesChanged();
        }
    }
}

