/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jump.algorithm.VertexHausdorffDistance;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.qa.diff.SegmentIndex;
import com.vividsolutions.jump.util.CoordinateArrays;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UniqueSegmentsWithToleranceFinder {
    private FeatureCollection queryFC;
    private SegmentIndex segIndex;
    private List resultSegs = new ArrayList();
    private Envelope queryEnv = new Envelope();

    public static double maximumDistance(LineSegment seg1, LineSegment seg2) {
        double dist;
        double maxDist = 0.0;
        maxDist = dist = seg1.p0.distance(seg2.p0);
        dist = seg1.p0.distance(seg2.p1);
        if (dist > maxDist) {
            maxDist = dist;
        }
        if ((dist = seg1.p1.distance(seg2.p0)) > maxDist) {
            maxDist = dist;
        }
        if ((dist = seg1.p1.distance(seg2.p1)) > maxDist) {
            maxDist = dist;
        }
        return maxDist;
    }

    public UniqueSegmentsWithToleranceFinder(FeatureCollection fc0, FeatureCollection fc1) {
        this.queryFC = fc0;
        this.segIndex = new SegmentIndex(fc1);
    }

    public List findUniqueSegments(double tolerance) {
        Iterator it = this.queryFC.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            Geometry geom = f.getGeometry();
            this.findUniqueSegments(geom, tolerance);
        }
        return this.resultSegs;
    }

    public void findUniqueSegments(Geometry geom, double tolerance) {
        List coordArrays = CoordinateArrays.toCoordinateArrays(geom, false);
        Iterator i = coordArrays.iterator();
        while (i.hasNext()) {
            this.findUniqueSegments((Coordinate[])i.next(), tolerance);
        }
    }

    public void findUniqueSegments(Coordinate[] coord, double tolerance) {
        for (int i = 0; i < coord.length - 1; ++i) {
            LineSegment querySeg = new LineSegment(coord[i], coord[i + 1]);
            querySeg.normalize();
            this.queryEnv.init(querySeg.p0, querySeg.p1);
            Envelope queryEnvExp = EnvelopeUtil.expand(this.queryEnv, tolerance);
            List testSegs = this.segIndex.query(queryEnvExp);
            if (this.hasSegmentWithinTolerance(querySeg, testSegs, tolerance)) continue;
            this.resultSegs.add(querySeg);
        }
    }

    private boolean hasSegmentWithinTolerance(LineSegment querySeg, List testSegs, double tolerance) {
        for (LineSegment testSeg : testSegs) {
            VertexHausdorffDistance vhd = new VertexHausdorffDistance(querySeg, testSeg);
            if (!(vhd.distance() < tolerance)) continue;
            return true;
        }
        return false;
    }
}

