/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.java2xml;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLBinder {
    private HashMap classToCustomConverterMap = new HashMap();

    public XMLBinder() {
        this.classToCustomConverterMap.put(Class.class, new CustomConverter(){

            public Object toJava(String value) {
                try {
                    return Class.forName(value);
                }
                catch (ClassNotFoundException e) {
                    Assert.shouldNeverReachHere();
                    return null;
                }
            }

            public String toXML(Object object) {
                return ((Class)object).getName();
            }
        });
        this.classToCustomConverterMap.put(Color.class, new CustomConverter(){

            public Object toJava(String value) {
                List parameters = StringUtil.fromCommaDelimitedString(value);
                return new Color(Integer.parseInt((String)parameters.get(0)), Integer.parseInt((String)parameters.get(1)), Integer.parseInt((String)parameters.get(2)), Integer.parseInt((String)parameters.get(3)));
            }

            public String toXML(Object object) {
                Color color = (Color)object;
                ArrayList<Integer> parameters = new ArrayList<Integer>();
                parameters.add(new Integer(color.getRed()));
                parameters.add(new Integer(color.getGreen()));
                parameters.add(new Integer(color.getBlue()));
                parameters.add(new Integer(color.getAlpha()));
                return StringUtil.toCommaDelimitedString(parameters);
            }
        });
        this.classToCustomConverterMap.put(Font.class, new CustomConverter(){

            public Object toJava(String value) {
                List parameters = StringUtil.fromCommaDelimitedString(value);
                return new Font((String)parameters.get(0), Integer.parseInt((String)parameters.get(1)), Integer.parseInt((String)parameters.get(2)));
            }

            public String toXML(Object object) {
                Font font = (Font)object;
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(font.getName());
                parameters.add(new Integer(font.getStyle()));
                parameters.add(new Integer(font.getSize()));
                return StringUtil.toCommaDelimitedString(parameters);
            }
        });
        this.classToCustomConverterMap.put(Double.TYPE, new CustomConverter(){

            public Object toJava(String value) {
                return new Double(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Double.class, new CustomConverter(){

            public Object toJava(String value) {
                return new Double(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Integer.TYPE, new CustomConverter(){

            public Object toJava(String value) {
                return new Integer(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Integer.class, new CustomConverter(){

            public Object toJava(String value) {
                return new Integer(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Long.class, new CustomConverter(){

            public Object toJava(String value) {
                return new Long(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(String.class, new CustomConverter(){

            public Object toJava(String value) {
                return value;
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Boolean.TYPE, new CustomConverter(){

            public Object toJava(String value) {
                return new Boolean(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(Boolean.class, new CustomConverter(){

            public Object toJava(String value) {
                return new Boolean(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
        this.classToCustomConverterMap.put(File.class, new CustomConverter(){

            public Object toJava(String value) {
                return new File(value);
            }

            public String toXML(Object object) {
                return object.toString();
            }
        });
    }

    private String specFilename(Class c) {
        return StringUtil.classNameWithoutPackageQualifiers(c.getName()) + ".java2xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List specElements(Class c) throws XMLBinderException, JDOMException, IOException {
        InputStream stream = this.specResourceStream(c);
        if (stream == null) {
            throw new XMLBinderException("Could not find java2xml file for " + c.getName() + " or its interfaces or superclasses");
        }
        try {
            Element root = new SAXBuilder().build(stream).getRootElement();
            if (!root.getAttributes().isEmpty()) {
                throw new XMLBinderException("Root element of " + this.specFilename(c) + " should not have attributes");
            }
            if (!root.getName().equals("root")) {
                throw new XMLBinderException("Root element of " + this.specFilename(c) + " should be named 'root'");
            }
            List list = root.getChildren();
            return list;
        }
        finally {
            stream.close();
        }
    }

    private InputStream specResourceStream(Class c) {
        for (Class type : LangUtil.classesAndInterfaces(c)) {
            Assert.isTrue((boolean)type.isAssignableFrom(c));
            InputStream stream = type.getResourceAsStream(this.specFilename(type));
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public void addCustomConverter(Class c, CustomConverter converter) {
        this.classToCustomConverterMap.put(c, converter);
    }

    protected void visit(List specElements, SpecVisitor visitor, Class c) throws Exception {
        for (Element specElement : specElements) {
            Attribute xmlName = specElement.getAttribute("xml-name");
            if (xmlName == null) {
                throw new XMLBinderException(StringUtil.classNameWithoutPackageQualifiers(c.getName()) + ": Expected 'xml-name' attribute in <" + specElement.getName() + "> but found none");
            }
            Attribute javaName = specElement.getAttribute("java-name");
            if (specElement.getName().equals("element")) {
                visitor.tagSpecFound(xmlName.getValue(), javaName != null ? javaName.getValue() : null, specElement.getChildren());
            }
            if (!specElement.getName().equals("attribute")) continue;
            visitor.attributeSpecFound(xmlName.getValue(), javaName.getValue());
        }
    }

    public Object toJava(String text, Class c) {
        return !text.equals("null") ? ((CustomConverter)this.classToCustomConverterMap.get(this.customConvertableClass(c))).toJava(text) : null;
    }

    protected boolean specifyingTypeExplicitly(Class c) throws XMLBinderException {
        if (this.hasCustomConverter(c)) {
            return false;
        }
        return c == Object.class || Modifier.isAbstract(c.getModifiers()) || c.isInterface();
    }

    protected Class fieldClass(Method setter) {
        Assert.isTrue((setter.getParameterTypes().length == 1 ? 1 : 0) != 0);
        return setter.getParameterTypes()[0];
    }

    public Method setter(Class c, String field) throws XMLBinderException {
        int i;
        Method[] methods = c.getMethods();
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().toUpperCase().equals("SET" + field.toUpperCase()) && !methods[i].getName().toUpperCase().equals("ADD" + field.toUpperCase()) || methods[i].getParameterTypes().length != 1) continue;
            return methods[i];
        }
        for (i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().toUpperCase().startsWith("SET" + field.toUpperCase()) && !methods[i].getName().toUpperCase().startsWith("ADD" + field.toUpperCase()) || methods[i].getParameterTypes().length != 1) continue;
            return methods[i];
        }
        throw new XMLBinderException("Could not find setter named like '" + field + "' in class " + c);
    }

    protected String toXML(Object object) {
        return ((CustomConverter)this.classToCustomConverterMap.get(this.customConvertableClass(object.getClass()))).toXML(object);
    }

    protected boolean hasCustomConverter(Class fieldClass) {
        return this.customConvertableClass(fieldClass) != null;
    }

    private Class customConvertableClass(Class c) {
        for (Class customConvertableClass : this.classToCustomConverterMap.keySet()) {
            if (!customConvertableClass.isAssignableFrom(c)) continue;
            return customConvertableClass;
        }
        return null;
    }

    public static class XMLBinderException
    extends Exception {
        public XMLBinderException(String message) {
            super(message);
        }
    }

    public static interface CustomConverter {
        public Object toJava(String var1);

        public String toXML(Object var1);
    }

    protected static interface SpecVisitor {
        public void tagSpecFound(String var1, String var2, List var3) throws Exception;

        public void attributeSpecFound(String var1, String var2) throws Exception;
    }
}

