/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.wms.BoundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MapLayer {
    private MapLayer parent = null;
    private String name;
    private String title;
    private ArrayList srsList;
    private ArrayList subLayers;
    private BoundingBox bbox;
    private ArrayList boundingBoxList;
    private boolean enabled = false;

    public MapLayer(String name, String title, Collection srsList, Collection subLayers, BoundingBox bbox) {
        this.name = name;
        this.title = title;
        this.srsList = new ArrayList(srsList);
        this.subLayers = new ArrayList(subLayers);
        Iterator it = subLayers.iterator();
        while (it.hasNext()) {
            ((MapLayer)it.next()).parent = this;
        }
        this.bbox = bbox;
    }

    public MapLayer(String name, String title, Collection srsList, Collection subLayers, BoundingBox bbox, ArrayList boundingBoxList) {
        this(name, title, srsList, subLayers, bbox);
        this.boundingBoxList = boundingBoxList;
    }

    public ArrayList getAllBoundingBoxList() {
        ArrayList allBoundingBoxList = new ArrayList();
        MapLayer mapLayer = this;
        allBoundingBoxList = this.getBoundingBoxList();
        if (allBoundingBoxList.size() > 0) {
            return allBoundingBoxList;
        }
        while (mapLayer != null) {
            if ((mapLayer = mapLayer.getParent()) == null) {
                return allBoundingBoxList;
            }
            allBoundingBoxList = mapLayer.getBoundingBoxList();
            if (allBoundingBoxList.size() <= 0) continue;
            return allBoundingBoxList;
        }
        return allBoundingBoxList;
    }

    public int numSubLayers() {
        return this.subLayers.size();
    }

    public MapLayer getSubLayer(int n) {
        return (MapLayer)this.subLayers.get(n);
    }

    public ArrayList getSubLayerList() {
        return (ArrayList)this.subLayers.clone();
    }

    public ArrayList getLayerList() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        list.add(this);
        Iterator it = this.subLayers.iterator();
        while (it.hasNext()) {
            list.addAll(((MapLayer)it.next()).getLayerList());
        }
        return list;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public MapLayer getParent() {
        return this.parent;
    }

    public BoundingBox getBoundingBox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        if (this.parent != null) {
            return this.parent.getBoundingBox();
        }
        return null;
    }

    public BoundingBox getLatLonBoundingBox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        if (this.parent != null) {
            return this.parent.getBoundingBox();
        }
        return null;
    }

    public ArrayList getBoundingBoxList() {
        return (ArrayList)this.boundingBoxList.clone();
    }

    public ArrayList getSRSList() {
        return (ArrayList)this.srsList.clone();
    }

    public Collection getFullSRSList() {
        ArrayList fullSRSList = new ArrayList(this.getSRSList());
        if (this.parent != null) {
            fullSRSList.addAll(this.parent.getFullSRSList());
        }
        return CollectionUtil.removeDuplicates(fullSRSList);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("WMSLayer {\n  name: \"" + this.name + "\"\n" + "  title: \"" + this.title + "\"\n" + "  srsList: " + this.srsList.toString() + "\n" + "  subLayers: [\n");
        for (int i = 0; i < this.subLayers.size(); ++i) {
            s.append(this.subLayers.get(i).toString() + ", ");
        }
        s.append("  ]\n  bbox: ");
        if (this.bbox != null) {
            s.append(this.bbox.toString());
        } else {
            s.append("null");
        }
        s.append("\n}\n");
        return s.toString();
    }
}

