/*
 * Decompiled with CFR 0.152.
 */
package de.fho.jump.pirol.utilities.attributes;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;

public class AttributeInfo
implements Comparable {
    protected AttributeType attributeType = null;
    protected String attributeName = null;
    protected String uniqueAttributeName = null;
    protected String unitIdentifier = null;
    protected Object nullValue = null;
    protected int dataBaseId = -1;
    protected int index = -1;

    public AttributeInfo(AttributeType attributeType, String attributeName, Object nullValue) {
        this(attributeType, attributeName);
        this.nullValue = nullValue;
    }

    public AttributeInfo(AttributeType attributeType, String attributeName) {
        this.attributeType = attributeType;
        this.attributeName = attributeName;
    }

    public AttributeInfo(String attributeName, Object nullValue) {
        this.attributeName = attributeName;
        this.nullValue = nullValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public String getUniqueAttributeName() {
        if (this.uniqueAttributeName == null) {
            return this.getAttributeName();
        }
        return this.uniqueAttributeName;
    }

    public void setUniqueAttributeName(String uniqueAttributeName) {
        this.uniqueAttributeName = uniqueAttributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public void setNullValue(Object nullValue) {
        if (this.attributeType != null) {
            if (this.attributeType.equals(AttributeType.DOUBLE) && !Double.class.isInstance(nullValue) || this.attributeType.equals(AttributeType.INTEGER) && !Integer.class.isInstance(nullValue)) {
                throw new IllegalArgumentException("default value is of a wrong type: " + nullValue.getClass().getName());
            }
            if (this.attributeType.equals(AttributeType.STRING) && !String.class.isInstance(nullValue)) {
                nullValue = new String(nullValue.toString());
            }
        }
        this.nullValue = nullValue;
    }

    public String getUnitIdentifier() {
        return this.unitIdentifier;
    }

    public void setUnitIdentifier(String unitIdentifier) {
        this.unitIdentifier = unitIdentifier;
    }

    public static AttributeInfo[] schema2AttributeInfoArray(FeatureSchema fs) {
        AttributeInfo[] result = new AttributeInfo[fs.getAttributeCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new AttributeInfo(fs.getAttributeType(i), fs.getAttributeName(i));
            result[i].setIndex(i);
        }
        return result;
    }

    public static FeatureSchema attributeInfoArray2FeatureSchema(AttributeInfo[] attributeInfos) {
        FeatureSchema result = new FeatureSchema();
        for (int i = 0; i < attributeInfos.length; ++i) {
            result.addAttribute(attributeInfos[i].getUniqueAttributeName(), attributeInfos[i].getAttributeType());
        }
        return result;
    }

    public String toString() {
        return this.getUniqueAttributeName();
    }

    public int compareTo(Object theOtherObject) {
        int iTheOtherIndex = ((AttributeInfo)theOtherObject).getIndex();
        int iThisIndex = this.getIndex();
        if (Math.min(iThisIndex, iTheOtherIndex) > -1) {
            Integer theOtherIndex = new Integer(iTheOtherIndex);
            Integer thisIndex = new Integer(iThisIndex);
            return thisIndex.compareTo(theOtherIndex);
        }
        throw new IllegalStateException("at least one index is not set correctly: " + iThisIndex + ", " + iTheOtherIndex);
    }

    public int getDataBaseId() {
        return this.dataBaseId;
    }

    public void setDataBaseId(int dataBaseId) {
        this.dataBaseId = dataBaseId;
    }
}

