/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class SaveLegendPlugIn
extends AbstractPlugIn {
    private String filename = null;

    public void initialize(PlugInContext context) throws Exception {
        EnableCheckFactory enableCheckFactory = new EnableCheckFactory(context.getWorkbenchContext());
        MultiEnableCheck enableCheck = new MultiEnableCheck().add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(enableCheckFactory.createExactlyNLayersMustBeSelectedCheck(1));
        new FeatureInstaller(context.getWorkbenchContext()).addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.LAYER}, this.getName() + "...", false, null, (EnableCheck)enableCheck);
    }

    public boolean execute(PlugInContext context) throws Exception {
        Layer layer = context.getSelectedLayer(0);
        LayerNamePanel layerPanel = context.getLayerNamePanel();
        if (!(layerPanel instanceof TreeLayerNamePanel)) {
            return false;
        }
        JTree newTree = this.createLayerTree(layer, (TreeLayerNamePanel)layerPanel);
        this.saveLegend(context, newTree);
        return true;
    }

    private void saveLegend(PlugInContext context, JTree tree) throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setApproveButtonText(I18N.get("deejump.plugin.SaveLegendPlugIn.Save"));
        fileChooser.setDialogTitle(I18N.get("deejump.plugin.SaveLegendPlugIn.Save-legend-as-image-png"));
        JPanel p = new JPanel();
        p.add(tree);
        fileChooser.setAccessory(p);
        if (0 == fileChooser.showOpenDialog((Component)context.getWorkbenchFrame())) {
            JFrame f = new JFrame(I18N.get("deejump.plugin.SaveLegendPlugIn.Save-legend-as-image-png"));
            f.getContentPane().add(tree);
            f.pack();
            SaveLegendPlugIn.saveComponentAsJPEG(tree, fileChooser.getSelectedFile().getAbsolutePath());
            f.setVisible(false);
            f.dispose();
        }
    }

    private JTree createLayerTree(Layer layer, TreeLayerNamePanel treePanel) {
        JTree tree = treePanel.getTree();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(layer.getName());
        for (int j = 0; j < tree.getModel().getChildCount(layer); ++j) {
            rootNode.add(new DefaultMutableTreeNode(tree.getModel().getChild(layer, j)));
        }
        JTree newTree = new JTree(rootNode);
        newTree.setCellRenderer(this.createColorThemingValueRenderer());
        return newTree;
    }

    public String getName() {
        return I18N.get("deejump.plugin.SaveLegendPlugIn.Save-legend");
    }

    public static void saveComponentAsJPEG(Component myComponent, String filename) throws IOException {
        if (!filename.endsWith(".png")) {
            filename = filename + ".png";
        }
        Dimension size = myComponent.getSize();
        BufferedImage myImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paint(g2);
        ImageIO.write((RenderedImage)myImage, "PNG", new File(filename));
    }

    private TreeCellRenderer createColorThemingValueRenderer() {
        return new TreeCellRenderer(){
            private JPanel panel = new JPanel(new GridBagLayout());
            private ColorPanel colorPanel = new ColorPanel();
            private JLabel label = new JLabel();
            {
                this.panel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                this.panel.setBackground(Color.white);
                this.label.setBackground(Color.white);
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String txt = "";
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof LayerTreeModel.ColorThemingValue) {
                    LayerTreeModel.ColorThemingValue entry = (LayerTreeModel.ColorThemingValue)userObject;
                    txt = entry.toString();
                    BasicStyle style = entry.getStyle();
                    this.colorPanel.setLineColor(style.isRenderingLine() ? GUIUtil.alphaColor((Color)style.getLineColor(), (int)style.getAlpha()) : GUIUtil.alphaColor((Color)Color.BLACK, (int)0));
                    this.colorPanel.setFillColor(style.isRenderingFill() ? GUIUtil.alphaColor((Color)style.getFillColor(), (int)style.getAlpha()) : GUIUtil.alphaColor((Color)Color.BLACK, (int)0));
                } else {
                    txt = (String)userObject;
                    this.colorPanel.setFillColor(Color.white);
                    this.colorPanel.setLineColor(Color.white);
                }
                this.label.setText(txt);
                return this.panel;
            }
        };
    }
}

