/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class BitmapVertexStyle
extends VertexStyle {
    private Image image;
    private Point2D point;
    private String fileName;

    public BitmapVertexStyle() {
    }

    public BitmapVertexStyle(String fileName) {
        super(null);
        if (fileName == null) {
            throw new NullPointerException("Image URL cannot be null.");
        }
        this.setFileName(fileName);
    }

    public void paint(Graphics2D g, Point2D p) {
        this.point = p;
        this.render(g);
    }

    protected void render(Graphics2D g) {
        g.drawImage(this.image, (int)this.point.getX() - this.image.getWidth(null) / 2, (int)this.point.getY() - this.image.getHeight(null) / 2, null);
    }

    public Image getImage() {
        return this.image;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFillColor(Color c) {
        super.setFillColor(c);
        if (this.fileName.toLowerCase().endsWith(".svg")) {
            this.setFileName(this.fileName);
        }
    }

    public void setLineColor(Color c) {
        super.setLineColor(c);
        if (this.fileName.toLowerCase().endsWith(".svg")) {
            this.setFileName(this.fileName);
        }
    }

    public void setSize(int size) {
        super.setSize(size);
        if (this.fileName != null && this.fileName.toLowerCase().endsWith(".svg")) {
            this.setFileName(this.fileName);
        }
    }

    public static String toHexColor(Color col) {
        if (col == null) {
            col = Color.black;
        }
        String scol = Integer.toHexString(col.getRGB() & 0xFFFFFF);
        while (scol.length() < 6) {
            scol = "0" + scol;
        }
        return "#" + scol;
    }

    public static StringBuffer updateSVGColors(File file, String stroke, String fill) throws IOException {
        String s;
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringWriter sout = new StringWriter((int)file.length());
        PrintWriter out = new PrintWriter(sout);
        while ((s = in.readLine()) != null) {
            s = s.replace("fill:#000000", "fill:" + fill);
            s = s.replace("fill:black", "fill:" + fill);
            s = s.replace("stroke:#000000", "stroke:" + stroke);
            s = s.replace("stroke:black", "stroke:" + stroke);
            out.println(s);
        }
        out.close();
        in.close();
        return sout.getBuffer();
    }

    public static BufferedImage getUpdatedSVGImage(String fileName, String stroke, String fill, int size) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size * size * 4);
        TranscoderOutput output = new TranscoderOutput(bos);
        PNGTranscoder trc = new PNGTranscoder();
        try {
            StringReader in = new StringReader(BitmapVertexStyle.updateSVGColors(new File(fileName), stroke, fill).toString());
            TranscoderInput input = new TranscoderInput(in);
            if (size > 0) {
                trc.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, new Float(size));
                trc.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, new Float(size));
            }
            trc.transcode(input, output);
            bos.close();
            ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
            MemoryCacheSeekableStream mcss = new MemoryCacheSeekableStream((InputStream)is);
            RenderedOp rop = JAI.create((String)"stream", (Object)mcss);
            return rop.getAsBufferedImage();
        }
        catch (TranscoderException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.image = fileName.toLowerCase().endsWith(".svg") ? BitmapVertexStyle.getUpdatedSVGImage(fileName, BitmapVertexStyle.toHexColor(this.getLineColor()), BitmapVertexStyle.toHexColor(this.getFillColor()), this.getSize()) : Toolkit.getDefaultToolkit().getImage(fileName);
    }
}

