/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codec;

import com.sun.media.jai.codec.SeekableStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.libtiff.jai.codec.XTIFFDecodeParam;
import org.libtiff.jai.codec.XTIFFEncodeParam;
import org.libtiff.jai.codec.XTIFFFactory;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.util.JaiI18N;

public class XTIFFDirectory
implements Serializable {
    private int imageType;
    protected static XTIFFFactory factory = new XTIFFFactory();
    protected static Hashtable tileCodecs = new Hashtable();
    protected transient SeekableStream stream;
    boolean isBigEndian;
    boolean _isTiled = false;
    TreeMap fieldIndex = new TreeMap();
    private static final int[] _sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public XTIFFDirectory() {
    }

    private static boolean isValidEndianTag(int endian) {
        return endian == 18761 || endian == 19789;
    }

    public boolean isTiled() {
        return this._isTiled;
    }

    protected void readHeader() throws IOException {
        this.stream.seek(0L);
        int endian = this.stream.readUnsignedShort();
        if (!XTIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(JaiI18N.getString("XTIFFDirectory1"));
        }
        this.isBigEndian = endian == 19789;
        int magic = this.readUnsignedShort(this.stream);
        if (magic != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("XTIFFDirectory2"));
        }
    }

    protected XTIFFDirectory(SeekableStream stream, int directory) throws IOException {
        this.stream = stream;
        long global_save_offset = stream.getFilePointer();
        this.readHeader();
        long ifd_offset = this.readUnsignedInt(stream);
        for (int i = 0; i < directory; ++i) {
            if (ifd_offset == 0L) {
                throw new IllegalArgumentException(JaiI18N.getString("XTIFFDirectory3"));
            }
            stream.seek(ifd_offset);
            int entries = this.readUnsignedShort(stream);
            stream.skip((long)(12 * entries));
            ifd_offset = this.readUnsignedInt(stream);
        }
        stream.seek(ifd_offset);
        this.initialize();
        stream.seek(global_save_offset);
    }

    protected XTIFFDirectory(SeekableStream stream, long ifd_offset) throws IOException {
        this.stream = stream;
        long global_save_offset = stream.getFilePointer();
        this.readHeader();
        stream.seek(ifd_offset);
        this.initialize();
        stream.seek(global_save_offset);
    }

    public int sizeOfType(int type) throws ArrayIndexOutOfBoundsException {
        return _sizeOfType[type];
    }

    public void addField(int tag, int type, int count, Object obj) {
        this.addField(factory.createField(tag, type, count, obj));
    }

    public static XTIFFField createField(int tag, int type, int count, Object obj) {
        return factory.createField(tag, type, count, obj);
    }

    public void addField(XTIFFField field) {
        this.fieldIndex.put(new Integer(field.tag), field);
    }

    protected void initialize() throws IOException {
        int numEntries = this.readUnsignedShort(this.stream);
        for (int i = 0; i < numEntries; ++i) {
            XTIFFField field;
            try {
                field = this.readField();
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                continue;
            }
            this.addField(field);
        }
    }

    public int getNumEntries() {
        return this.fieldIndex.size();
    }

    public XTIFFField getField(int tag) {
        return (XTIFFField)this.fieldIndex.get(new Integer(tag));
    }

    public boolean isTagPresent(int tag) {
        return this.fieldIndex.containsKey(new Integer(tag));
    }

    public int[] getTags() {
        int[] tags = new int[this.fieldIndex.size()];
        Iterator iter = this.fieldIndex.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            tags[i++] = (Integer)iter.next();
        }
        return tags;
    }

    public XTIFFField[] getFields() {
        XTIFFField[] fields = new XTIFFField[this.fieldIndex.size()];
        Iterator iter = this.fieldIndex.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            fields[i++] = (XTIFFField)iter.next();
        }
        return fields;
    }

    public byte getFieldAsByte(int tag, int index) {
        return this.getField(tag).getAsBytes()[index];
    }

    public byte getFieldAsByte(int tag) {
        return this.getFieldAsByte(tag, 0);
    }

    public long getFieldAsLong(int tag, int index) {
        return this.getField(tag).getAsLong(index);
    }

    public long getFieldAsLong(int tag) {
        return this.getFieldAsLong(tag, 0);
    }

    public float getFieldAsFloat(int tag, int index) {
        return this.getField(tag).getAsFloat(index);
    }

    public float getFieldAsFloat(int tag) {
        return this.getFieldAsFloat(tag, 0);
    }

    public double getFieldAsDouble(int tag, int index) {
        return this.getField(tag).getAsDouble(index);
    }

    public double getFieldAsDouble(int tag) {
        return this.getFieldAsDouble(tag, 0);
    }

    public Object readFieldValue(int tag, int type, int count) throws IOException, ArrayIndexOutOfBoundsException {
        Object obj = null;
        switch (type) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                byte[] bvalues = new byte[count];
                this.stream.readFully(bvalues, 0, count);
                if (type == 2) {
                    int index = 0;
                    int prevIndex = 0;
                    Vector<String> v = new Vector<String>();
                    while (index < count) {
                        while (index < count && bvalues[index++] != 0) {
                        }
                        v.add(new String(bvalues, prevIndex, index - prevIndex));
                        prevIndex = index;
                    }
                    count = v.size();
                    String[] strings = new String[count];
                    for (int c = 0; c < count; ++c) {
                        strings[c] = (String)v.elementAt(c);
                    }
                    obj = strings;
                    break;
                }
                obj = bvalues;
                break;
            }
            case 3: {
                char[] cvalues = new char[count];
                for (int j = 0; j < count; ++j) {
                    cvalues[j] = (char)this.readUnsignedShort(this.stream);
                }
                obj = cvalues;
                break;
            }
            case 4: {
                long[] lvalues = new long[count];
                for (int j = 0; j < count; ++j) {
                    lvalues[j] = this.readUnsignedInt(this.stream);
                }
                obj = lvalues;
                break;
            }
            case 5: {
                long[][] llvalues = new long[count][2];
                for (int j = 0; j < count; ++j) {
                    llvalues[j][0] = this.readUnsignedInt(this.stream);
                    llvalues[j][1] = this.readUnsignedInt(this.stream);
                }
                obj = llvalues;
                break;
            }
            case 8: {
                short[] svalues = new short[count];
                for (int j = 0; j < count; ++j) {
                    svalues[j] = this.readShort(this.stream);
                }
                obj = svalues;
                break;
            }
            case 9: {
                int[] ivalues = new int[count];
                for (int j = 0; j < count; ++j) {
                    ivalues[j] = this.readInt(this.stream);
                }
                obj = ivalues;
                break;
            }
            case 10: {
                int[][] iivalues = new int[count][2];
                for (int j = 0; j < count; ++j) {
                    iivalues[j][0] = this.readInt(this.stream);
                    iivalues[j][1] = this.readInt(this.stream);
                }
                obj = iivalues;
                break;
            }
            case 11: {
                float[] fvalues = new float[count];
                for (int j = 0; j < count; ++j) {
                    fvalues[j] = this.readFloat(this.stream);
                }
                obj = fvalues;
                break;
            }
            case 12: {
                double[] dvalues = new double[count];
                for (int j = 0; j < count; ++j) {
                    dvalues[j] = this.readDouble(this.stream);
                }
                obj = dvalues;
                break;
            }
            default: {
                System.err.println(JaiI18N.getString("XTIFFDirectory0"));
            }
        }
        return obj;
    }

    private XTIFFField readField() throws IOException, ArrayIndexOutOfBoundsException {
        int tag = this.readUnsignedShort(this.stream);
        int type = this.readUnsignedShort(this.stream);
        int count = (int)this.readUnsignedInt(this.stream);
        int value = 0;
        long nextTagOffset = this.stream.getFilePointer() + 4L;
        try {
            if (count * this.sizeOfType(type) > 4) {
                value = (int)this.readUnsignedInt(this.stream);
                this.stream.seek((long)value);
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.err.println(tag + " " + JaiI18N.getString("XTIFFDirectory4"));
            this.stream.seek(nextTagOffset);
            throw ae;
        }
        Object obj = this.readFieldValue(tag, type, count);
        this.stream.seek(nextTagOffset);
        return XTIFFDirectory.createField(tag, type, count, obj);
    }

    protected short readShort(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readShort();
        }
        return stream.readShortLE();
    }

    protected int readUnsignedShort(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            int val = stream.readUnsignedShort();
            return val;
        }
        int val = stream.readUnsignedShortLE();
        return val;
    }

    protected int readInt(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readInt();
        }
        return stream.readIntLE();
    }

    protected long readUnsignedInt(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    protected long readLong(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readLong();
        }
        return stream.readLongLE();
    }

    protected float readFloat(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readFloat();
        }
        return stream.readFloatLE();
    }

    protected double readDouble(SeekableStream stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readDouble();
        }
        return stream.readDoubleLE();
    }

    private static int readUnsignedShort(SeekableStream stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(SeekableStream stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    public static int getNumDirectories(SeekableStream stream) throws IOException {
        long pointer = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!XTIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException(JaiI18N.getString("XTIFFDirectory1"));
        }
        boolean isBigEndian = endian == 19789;
        int magic = XTIFFDirectory.readUnsignedShort(stream, isBigEndian);
        if (magic != 42) {
            throw new IllegalArgumentException(JaiI18N.getString("XTIFFDirectory2"));
        }
        stream.seek(4L);
        long offset = XTIFFDirectory.readUnsignedInt(stream, isBigEndian);
        int numDirectories = 0;
        while (offset != 0L) {
            ++numDirectories;
            stream.seek(offset);
            int entries = XTIFFDirectory.readUnsignedShort(stream, isBigEndian);
            stream.skip((long)(12 * entries));
            offset = XTIFFDirectory.readUnsignedInt(stream, isBigEndian);
        }
        stream.seek(pointer);
        return numDirectories;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public void setCompression(int compression) {
        this.addField(259, 3, 1, new char[]{(char)compression});
    }

    public int getCompression() {
        if (this.getField(259) == null) {
            return 1;
        }
        return (int)this.getFieldAsLong(259);
    }

    public void setIsTiled(boolean isTiled) {
        this._isTiled = isTiled;
    }

    public XTIFFTileCodec createTileCodec(XTIFFDecodeParam param) throws IOException {
        int compression = this.getCompression();
        XTIFFTileCodec codec = XTIFFDirectory.getTileCodec(compression);
        if (codec == null) {
            throw new IOException("Compression type (" + compression + ") not supported");
        }
        return codec.create(param);
    }

    public XTIFFTileCodec createTileCodec(XTIFFEncodeParam param) throws IOException {
        int compression = this.getCompression();
        XTIFFTileCodec codec = XTIFFDirectory.getTileCodec(compression);
        if (codec == null) {
            throw new IOException("Compression type (" + compression + ") not supported");
        }
        return codec.create(param);
    }

    public static void setFactory(XTIFFFactory fact) {
        factory = fact == null ? new XTIFFFactory() : fact;
    }

    public static XTIFFDirectory create(SeekableStream stream, int directory) throws IOException {
        return factory.createDirectory(stream, directory);
    }

    public static XTIFFDirectory create(SeekableStream stream, long ifd_offset) throws IOException {
        return factory.createDirectory(stream, ifd_offset);
    }

    public static XTIFFDirectory create() {
        return factory.createDirectory();
    }

    public static XTIFFTileCodec getTileCodec(int comp) {
        return (XTIFFTileCodec)tileCodecs.get(new Integer(comp));
    }

    public static void unRegisterTileCodec(int comp) {
        XTIFFTileCodec cod = XTIFFDirectory.getTileCodec(comp);
        tileCodecs.remove(cod);
    }

    public static void registerTileCodec(int comp, XTIFFTileCodec codec) {
        tileCodecs.put(new Integer(comp), codec);
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setImageType(int image_type) {
        this.imageType = image_type;
    }
}

