/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.operator;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import org.libtiff.jai.codecimpl.XTIFFCodec;
import org.libtiff.jai.codecimpl.XTIFFImage;

public class XTIFFDescriptor
extends OperationDescriptorImpl
implements RenderedImageFactory {
    private static final String[][] resources = new String[][]{{"GlobalName", "tiff"}, {"LocalName", "tiff"}, {"Vendor", "libtiff.org"}, {"Description", "A TIFF parser, extending the TIFF operation."}, {"DocURL", "http://www.geotiff.org/javadocs/XTIFFDescriptor.html"}, {"Version", "1.0"}, {"arg0Desc", "param1"}, {"arg1Desc", "param2"}};
    private static final String[] paramNames = new String[]{"stream", "param"};
    private static final Class[] paramClasses = new Class[]{SeekableStream.class, TIFFDecodeParam.class};
    private static final Object[] paramDefaults = new Object[]{null, null};

    public XTIFFDescriptor() {
        super(resources, 0, paramClasses, paramNames, paramDefaults);
    }

    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        StringBuffer msg = new StringBuffer();
        if (!this.validateParameters(paramBlock, msg)) {
            return null;
        }
        try {
            SeekableStream in = (SeekableStream)paramBlock.getObjectParameter(0);
            XTIFFImage image = new XTIFFImage(in, (TIFFDecodeParam)paramBlock.getObjectParameter(1), 0);
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void register(XTIFFDescriptor odesc) {
        OperationRegistry reg = JAI.getDefaultInstance().getOperationRegistry();
        reg.unregisterOperationDescriptor("tiff");
        reg.registerOperationDescriptor((OperationDescriptor)odesc, "tiff");
        reg.registerRIF("tiff", "org.libtiff.jai", (RenderedImageFactory)odesc);
        ImageCodec.unregisterCodec((String)"tiff");
        ImageCodec.registerCodec((ImageCodec)new XTIFFCodec());
    }

    public static void register() {
        XTIFFDescriptor odesc = new XTIFFDescriptor();
        XTIFFDescriptor.register(odesc);
    }
}

