/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import de.fho.jump.pirol.utilities.FormulaParsing.FormulaValue;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import de.fho.jump.pirol.utilities.debugOutput.DebugUserIds;
import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.ToolToMakeYourLifeEasier;
import org.openjump.core.apitools.comparisonandsorting.ObjectComparator;
import org.openjump.core.apitools.objecttyperoles.PirolFeatureCollection;
import org.openjump.util.metaData.MetaInformationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCollectionTools
extends ToolToMakeYourLifeEasier {
    protected FeatureCollection fc = null;
    protected List<Feature> featureList;
    private HashMap<Integer, Feature> fid2Object = new HashMap();
    protected static PersonalLogger logger = new PersonalLogger(DebugUserIds.ALL);

    public FeatureCollectionTools(FeatureCollection fc) {
        this.fc = fc;
        this.featureList = this.fc.getFeatures();
    }

    public FeatureCollectionTools(List<Feature> fcl) {
        this.featureList = fcl;
    }

    public Feature getFeature(int fid) {
        Integer FID = new Integer(fid);
        if (!this.fid2Object.containsKey(FID)) {
            this.fid2Object.put(FID, FeatureCollectionTools.getFeatureFromCollection(this.featureList, fid));
        }
        return this.fid2Object.get(FID);
    }

    public static Feature getFeatureFromCollection(List<Feature> features, int fid) {
        return FeatureCollectionTools.getFeatureFromCollection(features.toArray(new Feature[0]), fid);
    }

    public static Feature getFeatureFromCollection(Feature[] features, int fid) {
        for (int i = 0; i < features.length; ++i) {
            Feature feat = features[i];
            if (feat.getID() != fid) continue;
            return feat;
        }
        return null;
    }

    public static final PirolFeatureCollection cloneFeatureCollection(FeatureCollection fc) {
        FeatureSchema clonedSchema = (FeatureSchema)fc.getFeatureSchema().clone();
        FeatureDataset newFc = new FeatureDataset(clonedSchema);
        Feature[] featuresToCopy = FeatureCollectionTools.FeatureCollection2FeatureArray(fc);
        BasicFeature newFeat = null;
        AttributeType attrType = null;
        for (int i = 0; i < featuresToCopy.length; ++i) {
            newFeat = new BasicFeature(clonedSchema);
            for (int attr = 0; attr < clonedSchema.getAttributeCount(); ++attr) {
                attrType = clonedSchema.getAttributeType(attr);
                if (featuresToCopy[i].getAttribute(attr) != null) {
                    if (attrType.equals(AttributeType.DOUBLE)) {
                        newFeat.setAttribute(attr, (Object)new Double((Double)featuresToCopy[i].getAttribute(attr)));
                        continue;
                    }
                    if (attrType.equals(AttributeType.INTEGER)) {
                        newFeat.setAttribute(attr, (Object)new Integer((Integer)featuresToCopy[i].getAttribute(attr)));
                        continue;
                    }
                    if (attrType.equals(AttributeType.STRING)) {
                        newFeat.setAttribute(attr, (Object)((String)featuresToCopy[i].getAttribute(attr)).trim());
                        continue;
                    }
                    if (attrType.equals(AttributeType.GEOMETRY)) {
                        newFeat.setAttribute(attr, ((Geometry)featuresToCopy[i].getAttribute(attr)).clone());
                        continue;
                    }
                    if (attrType.equals(AttributeType.DATE)) {
                        newFeat.setAttribute(attr, ((Date)featuresToCopy[i].getAttribute(attr)).clone());
                        continue;
                    }
                    if (!attrType.equals(AttributeType.OBJECT)) continue;
                    logger.printError("not implemented!");
                    newFeat.setAttribute(attr, featuresToCopy[i].getAttribute(attr));
                    continue;
                }
                newFeat.setAttribute(attr, null);
            }
            newFc.add(newFeat);
        }
        return MetaInformationHandler.createPirolFeatureCollection(newFc);
    }

    public static Feature getFeatureFromCollection(FeatureCollection features, int fid) {
        return FeatureCollectionTools.getFeatureFromCollection(features.getFeatures(), fid);
    }

    public static double getAritmeticMiddleForAttribute(Feature[] features, String attr) {
        if (features == null || features.length == 0) {
            return Double.NaN;
        }
        Feature f = features[0];
        FeatureSchema fs = f.getSchema();
        int attrInd = fs.getAttributeIndex(attr);
        return FeatureCollectionTools.getAritmeticMiddleForAttribute(features, attrInd);
    }

    public static Object[] getMeanOrModeForAttributes(Feature[] features, String[] attrs) {
        int i;
        if (features == null || features.length == 0) {
            return null;
        }
        int numVals = features.length;
        int numAttrs = attrs.length;
        FeatureSchema fs = features[0].getSchema();
        Object[] meansOrModes = new Object[numAttrs];
        AttributeType[] ats = new AttributeType[numAttrs];
        Object[] sumsOrMaps = new Object[numAttrs];
        boolean[] atIsNumeric = new boolean[numAttrs];
        for (int i2 = 0; i2 < numAttrs; ++i2) {
            ats[i2] = fs.getAttributeType(attrs[i2]);
            atIsNumeric[i2] = FeatureCollectionTools.isAttributeTypeNumeric(ats[i2]);
            sumsOrMaps[i2] = atIsNumeric[i2] ? new Double(0.0) : new Object[]{new HashMap(), new Integer(0), null};
        }
        Feature[] featArray = features;
        int occ = 0;
        for (i = 0; i < featArray.length; ++i) {
            Feature currFeat = featArray[i];
            for (int j = 0; j < numAttrs; ++j) {
                if (atIsNumeric[j]) {
                    Double sum = (Double)sumsOrMaps[j];
                    if (currFeat.getAttribute(attrs[j]) != null) {
                        sumsOrMaps[j] = new Double(sum + ObjectComparator.getDoubleValue(currFeat.getAttribute(attrs[j])));
                        continue;
                    }
                    logger.printMinorError("skipped a value (NULL), when calculating mean for " + attrs[j]);
                    continue;
                }
                Object value = currFeat.getAttribute(attrs[j]);
                if (value.getClass().equals(String.class)) {
                    ((String)value).trim();
                }
                Map map = (Map)((Object[])sumsOrMaps[j])[0];
                Integer maxOcc = (Integer)((Object[])sumsOrMaps[j])[1];
                Object modus = ((Object[])sumsOrMaps[j])[2];
                if (map.containsKey(value)) {
                    occ = (Integer)map.get(value);
                    ++occ;
                    map.remove(value);
                } else {
                    occ = 1;
                }
                map.put(value, new Integer(occ));
                if (occ > maxOcc) {
                    maxOcc = new Integer(occ);
                    modus = value;
                }
                sumsOrMaps[j] = new Object[]{map, maxOcc, modus};
            }
        }
        for (i = 0; i < meansOrModes.length; ++i) {
            meansOrModes[i] = atIsNumeric[i] ? new Double((Double)sumsOrMaps[i] / (double)numVals) : ((Object[])sumsOrMaps[i])[2];
        }
        return meansOrModes;
    }

    public static Envelope getEnvelopeForFeatures(Feature[] features) {
        Envelope env = null;
        for (int i = 0; i < features.length; ++i) {
            Feature feat = features[i];
            if (env == null) {
                env = new Envelope(feat.getGeometry().getCoordinate());
                continue;
            }
            env.expandToInclude(feat.getGeometry().getCoordinate());
        }
        return env;
    }

    public static double getAritmeticMiddleForAttribute(List<Feature> features, int attr) {
        return FeatureCollectionTools.getAritmeticMiddleForAttribute(features.toArray(new Feature[0]), attr);
    }

    public static double getAritmeticMiddleForAttribute(Feature[] featArray, int attr) {
        double sumVals = 0.0;
        int numVals = 0;
        if (featArray.length == 0) {
            logger.printWarning("no features in list - return value will be NAN!");
            return Double.NaN;
        }
        Feature f = featArray[0];
        FeatureSchema fs = f.getSchema();
        if (FeatureCollectionTools.isAttributeTypeNumeric(fs.getAttributeType(attr))) {
            for (int i = 0; i < featArray.length; ++i) {
                Feature feat = featArray[i];
                double value = ObjectComparator.getDoubleValue(feat.getAttribute(attr));
                sumVals += value;
                ++numVals;
            }
        }
        return sumVals / (double)numVals;
    }

    public static Geometry getCenterOfMass(Feature[] features) {
        double sumX = 0.0;
        double sumY = 0.0;
        GeometryFactory gf = new GeometryFactory();
        if (features == null || features.length == 0) {
            return null;
        }
        for (int i = 0; i < features.length; ++i) {
            Feature feat = features[i];
            sumX += feat.getGeometry().getCoordinate().x;
            sumY += feat.getGeometry().getCoordinate().y;
        }
        double newX = sumX / (double)features.length;
        double newY = sumY / (double)features.length;
        return gf.createPoint(new Coordinate(newX, newY));
    }

    public static Set getSetOfDifferentAttributeValues(Feature[] features, String attr) {
        Feature f = features[0];
        FeatureSchema fs = f.getSchema();
        int attrInd = fs.getAttributeIndex(attr);
        return FeatureCollectionTools.getSetOfDifferentAttributeValues(features, attrInd);
    }

    public static Set<Object> getSetOfDifferentAttributeValues(Feature[] features, int attr) {
        Feature[] featArray = features;
        int numFeats = featArray.length;
        HashSet<Object> differentValues = new HashSet<Object>();
        for (int i = numFeats - 1; i >= 0; --i) {
            Object val = featArray[i].getAttribute(attr);
            differentValues.add(val);
        }
        return differentValues;
    }

    public static int getNumOfDifferentAttributeValues(Feature[] features, String attr) {
        Feature f = features[0];
        FeatureSchema fs = f.getSchema();
        int attrInd = fs.getAttributeIndex(attr);
        return FeatureCollectionTools.getNumOfDifferentAttributeValues(features, attrInd);
    }

    public static int getNumOfDifferentAttributeValues(Feature[] features, int attr) {
        return FeatureCollectionTools.getSetOfDifferentAttributeValues(features, attr).size();
    }

    public static Object getModusForAttribute(Feature[] features, String attr) {
        Feature f = features[0];
        FeatureSchema fs = f.getSchema();
        int attrInd = fs.getAttributeIndex(attr);
        return FeatureCollectionTools.getModusForAttribute(features, attrInd);
    }

    public static final HashMap<Object, Integer>[] getValueAppearancesCount(Feature[] features, int[] attrs) {
        HashMap[] value2NumAppearanceMaps = new HashMap[attrs.length];
        for (int i = 0; i < attrs.length; ++i) {
            value2NumAppearanceMaps[i] = new HashMap();
        }
        for (int i = 0; i < features.length; ++i) {
            Feature feat = features[i];
            for (int attInd = 0; attInd < attrs.length; ++attInd) {
                Object value = feat.getAttribute(attrs[attInd]);
                if (!value2NumAppearanceMaps[attInd].containsKey(value)) {
                    value2NumAppearanceMaps[attInd].put(value, 1);
                    continue;
                }
                value2NumAppearanceMaps[attInd].put(value, (Integer)value2NumAppearanceMaps[attInd].get(value) + 1);
            }
        }
        return value2NumAppearanceMaps;
    }

    public static Object getModusForAttribute(Feature[] features, int attr) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        Object modus = null;
        int maxNr = 0;
        if (features == null || features.length == 0) {
            return null;
        }
        for (Feature feat : features) {
            int occ;
            Object value = feat.getAttribute(attr);
            if (value.getClass().getName().equals(String.class.getName())) {
                ((String)value).trim();
            }
            if (map.containsKey(value)) {
                occ = (Integer)map.get(value);
                ++occ;
                map.remove(value);
            } else {
                occ = 1;
            }
            map.put(value, new Integer(occ));
            if (occ <= maxNr) continue;
            maxNr = occ;
            modus = value;
        }
        return modus;
    }

    public static void deleteFeatures(List<Feature> features, PlugInContext context) {
        Map layer2FeatList = LayerTools.getLayer2FeatureMap(features, context);
        Layer[] layersWithFeatures = layer2FeatList.keySet().toArray(new Layer[0]);
        for (int i = 0; i < layersWithFeatures.length; ++i) {
            EditTransaction edtr = new EditTransaction(new ArrayList(), "delete features", layersWithFeatures[i], true, true, context.getLayerViewPanel());
            Feature[] selFeatsOfLayer = ((List)layer2FeatList.get(layersWithFeatures[i])).toArray(new Feature[0]);
            for (int j = 0; j < selFeatsOfLayer.length; ++j) {
                edtr.deleteFeature(selFeatsOfLayer[j]);
            }
            edtr.commit();
            edtr.clearEnvelopeCaches();
        }
    }

    public static Feature copyFeature(Feature feat) {
        BasicFeature newFeat = new BasicFeature(feat.getSchema());
        int numAttr = feat.getSchema().getAttributeCount();
        for (int i = 0; i < numAttr; ++i) {
            newFeat.setAttribute(feat.getSchema().getAttributeName(i), feat.getAttribute(i));
        }
        newFeat.setGeometry(feat.getGeometry());
        return newFeat;
    }

    public static Feature copyFeatureAndSetFeatureSchema(Feature feat, FeatureSchema newFs) {
        feat = feat.clone(true);
        FeatureSchema fs = feat.getSchema();
        BasicFeature newFeat = new BasicFeature(newFs);
        int numAttr = feat.getSchema().getAttributeCount();
        for (int i = 0; i < numAttr; ++i) {
            newFeat.setAttribute(fs.getAttributeName(i), feat.getAttribute(fs.getAttributeName(i)));
        }
        newFeat.setGeometry(feat.getGeometry());
        return newFeat;
    }

    public String getUniqueAttributeName(String attr) {
        return FeatureCollectionTools.getUniqueAttributeName(this.fc, attr);
    }

    public static String getUniqueAttributeName(FeatureCollection fc, String attr) {
        FeatureSchema fs = fc.getFeatureSchema();
        String newName = new String(attr);
        String suffix = "";
        int i = 2;
        while (FeatureCollectionTools.attributeExistsInSchema(fs, newName + suffix)) {
            suffix = " (" + i + ")";
            ++i;
        }
        return newName + suffix;
    }

    protected static boolean attributeExistsInSchema(FeatureSchema fs, String attr) {
        try {
            int index = fs.getAttributeIndex(attr);
            return index >= 0;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public PirolFeatureCollection addAttributeToFeatureCollection(String attr, AttributeType at, Object defaultVal) {
        if (this.fc != null) {
            return FeatureCollectionTools.addAttributeToFeatureCollection(this.fc, attr, at, defaultVal, true);
        }
        return null;
    }

    public static boolean isAttributeTypeNumeric(AttributeType at) {
        return at.equals(AttributeType.DOUBLE) || at.equals(AttributeType.INTEGER);
    }

    public static PirolFeatureCollection applyFormulaToFeatureCollection(FeatureCollection oldFc, AttributeInfo attrInfo, FormulaValue formula, boolean clearOldFeatureCollection) {
        PirolFeatureCollection newFc = FeatureCollectionTools.addAttributeToFeatureCollection(oldFc, attrInfo, clearOldFeatureCollection);
        Feature[] features = newFc.getFeatures().toArray(new Feature[0]);
        int numFeats = features.length;
        int attrInd = newFc.getFeatureSchema().getAttributeIndex(attrInfo.getUniqueAttributeName());
        for (int i = 0; i < numFeats; ++i) {
            Feature feat = features[i];
            feat.setAttribute(attrInd, (Object)new Double(formula.getValue(feat)));
            if (i % 500 != 0) continue;
            logger.printDebug("done: " + i);
        }
        return newFc;
    }

    public static PirolFeatureCollection addAttributeToFeatureCollection(FeatureCollection fc, AttributeInfo attrInfo) {
        return FeatureCollectionTools.addAttributeToFeatureCollection(fc, attrInfo.getUniqueAttributeName(), attrInfo.getAttributeType(), attrInfo.getNullValue(), true);
    }

    public static PirolFeatureCollection addAttributeToFeatureCollection(FeatureCollection fc, AttributeInfo attrInfo, boolean clearOldFeatureCollection) {
        return FeatureCollectionTools.addAttributeToFeatureCollection(fc, attrInfo.getUniqueAttributeName(), attrInfo.getAttributeType(), attrInfo.getNullValue(), clearOldFeatureCollection);
    }

    public static PirolFeatureCollection addAttributeToFeatureCollection(FeatureCollection fc, String attr, AttributeType at, Object defaultVal, boolean clearOldFeatureCollection) {
        FeatureSchema fs = (FeatureSchema)fc.getFeatureSchema().clone();
        fs.addAttribute(attr, at);
        MetaInformationHandler mih = new MetaInformationHandler(MetaInformationHandler.createPirolFeatureCollection(fc));
        PirolFeatureCollection newFc = MetaInformationHandler.createPirolFeatureCollection(new FeatureDataset(fs));
        if (mih.containsMetaInformation()) {
            newFc.setMetaInformation(mih.getExistentMetaInformationMap());
        }
        mih = null;
        if (at.equals(AttributeType.INTEGER) && Double.class.isInstance(defaultVal)) {
            defaultVal = new Integer(((Double)defaultVal).intValue());
        }
        Feature[] featArray = fc.getFeatures().toArray(new Feature[0]);
        if (clearOldFeatureCollection) {
            fc.clear();
        }
        int featuresDone = 0;
        int i = featArray.length - 1;
        while (i >= 0) {
            Feature feat = featArray[i];
            Feature newFeat = FeatureCollectionTools.copyFeatureAndSetFeatureSchema(feat, fs);
            newFeat.setAttribute(attr, defaultVal);
            newFc.add(newFeat);
            if (i % 10000 == 0 && i != 0) {
                featArray = (Feature[])FeatureCollectionTools.resizeArray(featArray, featArray.length - featuresDone);
                featuresDone = 0;
                if (i % 50000 == 0) {
                    System.gc();
                }
            }
            --i;
            ++featuresDone;
        }
        featArray = null;
        return newFc;
    }

    public static PirolFeatureCollection addAttributeToFeatureCollection(FeatureCollection fc, String attr, AttributeType at, Object defaultVal) {
        return FeatureCollectionTools.addAttributeToFeatureCollection(fc, attr, at, defaultVal, true);
    }

    public PirolFeatureCollection addAttributesToFeatureCollection(List attributeInfos) {
        return FeatureCollectionTools.addAttributesToFeatureCollection(this.fc, attributeInfos);
    }

    public static PirolFeatureCollection addAttributesToFeatureCollection(FeatureCollection fc, List<AttributeInfo> attributeInfos) {
        return FeatureCollectionTools.addAttributesToFeatureCollection(fc, attributeInfos.toArray(new AttributeInfo[0]));
    }

    public static PirolFeatureCollection addAttributesToFeatureCollection(FeatureCollection fc, AttributeInfo[] attributeInfos) {
        return FeatureCollectionTools.addAttributesToFeatureCollection(fc, attributeInfos, true);
    }

    public static PirolFeatureCollection addAttributesToFeatureCollection(FeatureCollection fc, AttributeInfo[] attributeInfos, boolean clearOriginalFeatureCollection) {
        AttributeInfo attrInfo;
        FeatureSchema fs = (FeatureSchema)fc.getFeatureSchema().clone();
        MetaInformationHandler mih = new MetaInformationHandler(MetaInformationHandler.createPirolFeatureCollection(fc));
        for (int i = 0; i < attributeInfos.length; ++i) {
            attrInfo = attributeInfos[i];
            fs.addAttribute(attrInfo.getUniqueAttributeName(), attrInfo.getAttributeType());
        }
        PirolFeatureCollection newFc = MetaInformationHandler.createPirolFeatureCollection(new FeatureDataset(fs));
        if (mih.containsMetaInformation()) {
            newFc.setMetaInformation(mih.getExistentMetaInformationMap());
        }
        mih = null;
        Feature[] featArray = fc.getFeatures().toArray(new Feature[0]);
        if (clearOriginalFeatureCollection) {
            fc.clear();
        }
        int featuresDone = 0;
        int i = featArray.length - 1;
        while (i >= 0) {
            Feature feat = featArray[i];
            Feature newFeat = FeatureCollectionTools.copyFeatureAndSetFeatureSchema(feat, fs);
            for (int j = 0; j < attributeInfos.length; ++j) {
                attrInfo = attributeInfos[j];
                newFeat.setAttribute(attrInfo.getUniqueAttributeName(), attrInfo.getNullValue());
            }
            newFc.add(newFeat);
            if (i % 10000 == 0 && i != 0) {
                featArray = (Feature[])FeatureCollectionTools.resizeArray(featArray, featArray.length - featuresDone);
                featuresDone = 0;
                if (i % 50000 == 0) {
                    System.gc();
                }
                logger.printDebug("adding attribute, features left to do " + i);
            }
            --i;
            ++featuresDone;
        }
        featArray = null;
        return newFc;
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static double[] getMinMaxAttributeValue(Feature[] featArray, FeatureSchema fs, String attr) {
        double[] minmax = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        if (fs.getAttributeType(attr) == AttributeType.INTEGER || fs.getAttributeType(attr) == AttributeType.DOUBLE) {
            for (int i = featArray.length - 1; i >= 0; --i) {
                Feature feat = featArray[i];
                if (feat.getAttribute(attr) != null) {
                    double value = ObjectComparator.getDoubleValue(feat.getAttribute(attr));
                    if (value < minmax[0]) {
                        minmax[0] = value;
                    }
                    if (!(value > minmax[1])) continue;
                    minmax[1] = value;
                    continue;
                }
                logger.printMinorError("skipped value (NULL), when checking min./max. values for Attribute " + attr);
            }
        }
        return minmax;
    }

    public static double getSumAttributeValue(Feature[] featArray, FeatureSchema fs, String attr) {
        double sum = 0.0;
        if (fs.getAttributeType(attr) == AttributeType.INTEGER || fs.getAttributeType(attr) == AttributeType.DOUBLE) {
            for (int i = featArray.length - 1; i >= 0; --i) {
                Feature feat = featArray[i];
                if (feat.getAttribute(attr) != null) {
                    double value = ObjectComparator.getDoubleValue(feat.getAttribute(attr));
                    sum += value;
                    continue;
                }
                logger.printMinorError("skipped value (NULL), when checking sum values for Attribute " + attr);
            }
        }
        return sum;
    }

    public static double[] getMinMaxAttributeValue(FeatureCollection features, String attr) {
        return FeatureCollectionTools.getMinMaxAttributeValue(FeatureCollectionTools.FeatureCollection2FeatureArray(features), features.getFeatureSchema(), attr);
    }

    public static Feature[] FeatureCollection2FeatureArray(FeatureCollection fc) {
        return fc.getFeatures().toArray(new Feature[0]);
    }

    public static Feature[] FeatureCollection2FeatureArray(List<Feature> features) {
        return features.toArray(new Feature[0]);
    }

    public static ArrayList<Feature> convertToPointFeature(Feature f, boolean accountForRings) {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Feature> points = new ArrayList<Feature>();
        Coordinate[] coords = f.getGeometry().getCoordinates();
        int lastCoord = coords.length;
        if (accountForRings && coords[lastCoord - 1].equals2D(coords[0])) {
            lastCoord = coords.length - 1;
        }
        for (int i = 0; i < lastCoord; ++i) {
            Point pt = gf.createPoint(coords[i]);
            Feature fNew = FeatureCollectionTools.copyFeature(f);
            fNew.setGeometry((Geometry)pt);
            points.add(fNew);
        }
        return points;
    }
}

