/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.srid;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JInternalFrame;
import org.openjump.core.ccordsys.srid.SRIDStyle;

public class EnsureAllLayersHaveSRIDStylePlugIn
extends AbstractPlugIn {
    public void initialize(PlugInContext context) throws Exception {
        this.initializeCurrentAndFutureInternalFrames(context.getWorkbenchFrame(), new Block(){
            private Collection initializedFrames = new ArrayList();

            public Object yield(Object internalFrame) {
                if (!this.initializedFrames.contains(internalFrame)) {
                    EnsureAllLayersHaveSRIDStylePlugIn.this.initialize((JInternalFrame)internalFrame);
                    this.initializedFrames.add(internalFrame);
                }
                return null;
            }
        });
    }

    private void initialize(JInternalFrame internalFrame) {
        if (!(internalFrame instanceof LayerManagerProxy)) {
            return;
        }
        this.initialize(((LayerManagerProxy)internalFrame).getLayerManager());
    }

    private void initialize(LayerManager layerManager) {
        for (Layer layer : layerManager) {
            this.ensureHasSRIDStyle(layer);
        }
        layerManager.addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (e.getLayerable() instanceof Layer) {
                    EnsureAllLayersHaveSRIDStylePlugIn.this.ensureHasSRIDStyle((Layer)e.getLayerable());
                }
            }

            public void categoryChanged(CategoryEvent e) {
            }
        });
    }

    private void ensureHasSRIDStyle(Layer layer) {
        if (layer.getStyle(SRIDStyle.class) != null) {
            return;
        }
        SRIDStyle sridStyle = new SRIDStyle();
        if (layer.getFeatureCollectionWrapper().size() > 0) {
            sridStyle.setSRID(((Feature)layer.getFeatureCollectionWrapper().iterator().next()).getGeometry().getSRID());
        }
        layer.addStyle((Style)sridStyle);
    }

    private void initializeCurrentAndFutureInternalFrames(WorkbenchFrame workbenchFrame, final Block block) {
        workbenchFrame.getDesktopPane().addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent e) {
                if (!(e.getChild() instanceof JInternalFrame)) {
                    return;
                }
                block.yield((JInternalFrame)e.getChild());
            }
        });
        for (JInternalFrame internalFrame : Arrays.asList(workbenchFrame.getInternalFrames())) {
            block.yield(internalFrame);
        }
    }
}

