/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.srid;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import java.util.Iterator;

public class SRIDStyle
implements Style {
    private int srid = -1;
    private boolean initialized = false;
    private boolean enabled = true;

    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
    }

    public void initialize(Layer layer) {
        if (this.initialized) {
            return;
        }
        this.updateSRIDs(layer);
        layer.getLayerManager().addLayerListener(new LayerListener(){

            public void featuresChanged(FeatureEvent e) {
                for (Feature feature : e.getFeatures()) {
                    feature.getGeometry().setSRID(SRIDStyle.this.srid);
                }
            }

            public void layerChanged(LayerEvent e) {
            }

            public void categoryChanged(CategoryEvent e) {
            }
        });
        this.initialized = true;
    }

    public void updateSRIDs(Layer layer) {
        Iterator i = layer.getFeatureCollectionWrapper().iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            feature.getGeometry().setSRID(this.srid);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }
}

