/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.geomutils;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;

public class MathVector
implements Cloneable,
Serializable {
    private double x;
    private double y;
    private double mag;

    public MathVector() {
        this(0.0, 0.0);
    }

    public MathVector(Coordinate coord) {
        this(coord.x, coord.y);
    }

    public MathVector(double x, double y) {
        this.x = new Double(x).isNaN() ? 0.0 : x;
        this.y = new Double(y).isNaN() ? 0.0 : y;
        this.mag = Math.sqrt(x * x + y * y);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public Coordinate getCoord() {
        return new Coordinate(this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public boolean equals(Object object) {
        if (object instanceof MathVector) {
            MathVector vector = (MathVector)object;
            return this.x == vector.x() && this.y == vector.y();
        }
        return false;
    }

    public Object clone() {
        return new MathVector(this.x, this.y);
    }

    public double magnitude() {
        return this.mag;
    }

    public MathVector add(MathVector vector) {
        return new MathVector(this.x + vector.x(), this.y + vector.y());
    }

    public MathVector scale(double number) {
        return new MathVector(this.x * number, this.y * number);
    }

    public MathVector unit() {
        if (this.mag == 0.0) {
            return new MathVector();
        }
        return new MathVector(this.x / this.mag, this.y / this.mag);
    }

    public double dot(MathVector vector) {
        return this.x * vector.x() + this.y * vector.y();
    }

    public double distance(MathVector vector) {
        return this.scale(-1.0).add(vector).magnitude();
    }

    public MathVector vectorBetween(MathVector vector) {
        return new MathVector(this.x - vector.x(), this.y - vector.y());
    }

    public double angleRad(MathVector vector) {
        return Math.acos(this.dot(vector) / (this.mag * vector.magnitude()));
    }

    public double angleDeg(MathVector vector) {
        return Math.toDegrees(Math.acos(this.dot(vector) / (this.mag * vector.magnitude())));
    }

    public MathVector rotateDeg(double angle) {
        double tr = Math.toRadians(angle);
        double ct = Math.cos(tr);
        double st = Math.sin(tr);
        return new MathVector(this.x * ct + this.y * st, this.y * ct - st * this.x);
    }

    public MathVector rotateRad(double angle) {
        double tr = angle;
        double ct = Math.cos(tr);
        double st = Math.sin(tr);
        return new MathVector(this.x * ct + this.y * st, this.y * ct - st * this.x);
    }
}

