/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.famfam.IconLoaderFamFam;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.IOException;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.SelectRasterImageFilesPanel;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.ui.plugin.file.OpenRecentPlugIn;
import org.openjump.core.ui.plugin.file.open.ChooseProjectPanel;
import org.openjump.core.ui.plugin.layer.pirolraster.LoadSextanteRasterImagePlugIn;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageWizardPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;
import org.openjump.io.PropertiesHandler;
import org.openjump.util.metaData.MetaInformationHandler;

public class AddRasterImageLayerWizard
extends AbstractWizardGroup {
    public static final String KEY = AddRasterImageLayerWizard.class.getName();
    private WorkbenchContext workbenchContext;
    private ChooseProjectPanel chooseProjectPanel;
    private SelectRasterImageFilesPanel selectFilesPanel;
    private File[] files;
    protected PropertiesHandler properties = null;
    protected WorldFileHandler worldFileHandler = null;
    protected static String propertiesFile = "RasterImage.properties";
    protected String KEY_ALLWAYSACCEPT_TWF_EXT = "allwaysCheckForTWFExtension";
    protected String KEY_ZOOM_TO_INSERTED_IMAGE = "zoomToImage";
    protected boolean allwaysLookForTFWExtension = true;
    protected boolean zoomToInsertedImage = true;
    private String imageFileName = "";
    private String cachedLayer = "default-layer-name";

    public AddRasterImageLayerWizard(WorkbenchContext workbenchContext) {
        super(I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Sextante-Raster-Image"), IconLoaderFamFam.icon((String)"image.png"), SelectRasterImageFilesPanel.KEY);
        this.workbenchContext = workbenchContext;
    }

    public AddRasterImageLayerWizard(WorkbenchContext workbenchContext, File[] files) {
        this.workbenchContext = workbenchContext;
        this.files = files;
    }

    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        this.initPanels(workbenchContext);
        this.selectFilesPanel.setDialog(dialog);
    }

    private void initPanels(WorkbenchContext workbenchContext) {
        this.selectFilesPanel = new SelectRasterImageFilesPanel(workbenchContext);
        this.addPanel(this.selectFilesPanel);
    }

    public void run(WizardDialog dialog, TaskMonitor monitor) {
        this.properties = new PropertiesHandler(propertiesFile);
        if (this.files == null) {
            File[] selectedFiles = this.selectFilesPanel.getSelectedFiles();
            this.open(selectedFiles, monitor);
        } else {
            this.open(this.files, monitor);
        }
    }

    private void open(File[] files, TaskMonitor monitor) {
        for (File file : files) {
            this.open(file, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file, TaskMonitor monitor) {
        try {
            String selectedFilename;
            this.properties.setProperty(LoadSextanteRasterImagePlugIn.KEY_PATH, file.getPath());
            this.properties.store(" " + this.KEY_ZOOM_TO_INSERTED_IMAGE + I18N.get("RasterImagePlugIn.28") + this.KEY_ALLWAYSACCEPT_TWF_EXT + I18N.get("RasterImagePlugIn.29") + LoadSextanteRasterImagePlugIn.KEY_PATH + I18N.get("RasterImagePlugIn.30"));
            this.imageFileName = selectedFilename = file.getPath();
            this.cachedLayer = selectedFilename.substring(selectedFilename.lastIndexOf(File.separator) + 1, selectedFilename.lastIndexOf("."));
            boolean imageAdded = false;
            Point imageDimensions = RasterImageLayer.getImageDimensions(this.workbenchContext, selectedFilename);
            Envelope env = this.getGeoReferencing(selectedFilename, this.allwaysLookForTFWExtension, imageDimensions, this.workbenchContext);
            if (env != null) {
                imageAdded = this.addImage(this.workbenchContext, env, imageDimensions);
            }
            OpenRecentPlugIn.get(this.workbenchContext).addRecentFile(file);
        }
        catch (Exception e) {
            monitor.report(e);
        }
    }

    private boolean addImage(WorkbenchContext context, Envelope envelope, Point imageDimensions) {
        String newLayerName = context.getLayerManager().uniqueLayerName(this.cachedLayer);
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.createPlugInContext().getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException e1) {
            // empty catch block
        }
        int layersAsideImage = context.getLayerManager().getLayerables(Layerable.class).size();
        RasterImageLayer rLayer = new RasterImageLayer(newLayerName, context.getLayerManager(), this.imageFileName, null, envelope);
        MetaInformationHandler mih = new MetaInformationHandler(rLayer);
        mih.addMetaInformation("file-name", this.imageFileName);
        mih.addMetaInformation("resolution", imageDimensions.x + " (px) x " + imageDimensions.y + " (px)");
        mih.addMetaInformation("real-world-width", new Double(envelope.getWidth()));
        mih.addMetaInformation("real-world-height", new Double(envelope.getHeight()));
        context.getLayerManager().addLayerable(catName, (Layerable)rLayer);
        if (this.zoomToInsertedImage || layersAsideImage == 0) {
            try {
                context.getLayerViewPanel().getViewport().zoom(envelope);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
        }
        return true;
    }

    protected Envelope getGeoReferencing(String fileName, boolean allwaysLookForTFWExtension, Point imageDimensions, WorkbenchContext context) throws IOException {
        Envelope env = null;
        this.worldFileHandler = new WorldFileHandler(fileName, allwaysLookForTFWExtension);
        if (imageDimensions == null) {
            context.getWorkbench().getFrame().warnUser(I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.can-not-determine-image-dimensions"));
            return null;
        }
        if (this.worldFileHandler.isWorldFileExistentForImage() != null) {
            env = this.worldFileHandler.readWorldFile(imageDimensions.x, imageDimensions.y);
        }
        if (env == null) {
            boolean isGeoTiff = false;
            if (fileName.toLowerCase().endsWith(".tif") || fileName.toLowerCase().endsWith(".tiff")) {
                Coordinate tiePoint = null;
                Coordinate pixelOffset = null;
                Coordinate pixelScale = null;
                double[] doubles = null;
                FileSeekableStream fileSeekableStream = new FileSeekableStream(fileName);
                TIFFDirectory tiffDirectory = new TIFFDirectory((SeekableStream)fileSeekableStream, 0);
                TIFFField[] availTags = tiffDirectory.getFields();
                for (int i = 0; i < availTags.length; ++i) {
                    if (availTags[i].getTag() == 33922) {
                        doubles = availTags[i].getAsDoubles();
                        if (doubles.length != 6) {
                            context.getWorkbench().getFrame().warnUser("unsupported value for ModelTiepointTag (33922)");
                            break;
                        }
                        if (doubles[0] != 0.0 || doubles[1] != 0.0 || doubles[2] != 0.0) {
                            pixelOffset = doubles[2] == 0.0 ? new Coordinate(doubles[0], doubles[1]) : new Coordinate(doubles[0], doubles[1], doubles[2]);
                        }
                        if (doubles[5] == 0.0) {
                            tiePoint = new Coordinate(doubles[3], doubles[4]);
                            continue;
                        }
                        tiePoint = new Coordinate(doubles[3], doubles[4], doubles[5]);
                        continue;
                    }
                    if (availTags[i].getTag() != 33550) continue;
                    doubles = availTags[i].getAsDoubles();
                    pixelScale = doubles[2] == 0.0 ? new Coordinate(doubles[0], doubles[1]) : new Coordinate(doubles[0], doubles[1], doubles[2]);
                }
                fileSeekableStream.close();
                if (tiePoint != null && pixelScale != null) {
                    isGeoTiff = true;
                    Coordinate upperLeft = null;
                    Coordinate lowerRight = null;
                    upperLeft = pixelOffset == null ? tiePoint : new Coordinate(tiePoint.x - pixelOffset.x * pixelScale.x, tiePoint.y - pixelOffset.y * pixelScale.y);
                    lowerRight = new Coordinate(upperLeft.x + (double)imageDimensions.x * pixelScale.x, upperLeft.y - (double)imageDimensions.y * pixelScale.y);
                    env = new Envelope(upperLeft, lowerRight);
                }
            }
            if (!isGeoTiff || env == null) {
                context.getWorkbench().getFrame().warnUser(I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.no-worldfile-found"));
                WizardDialog d = new WizardDialog((Frame)context.getWorkbench().getFrame(), I18N.get("RasterImagePlugIn.34") + this.worldFileHandler.getWorldFileName() + I18N.get("RasterImagePlugIn.35"), context.getErrorHandler());
                d.init(new WizardPanel[]{new RasterImageWizardPanel()});
                d.setSize(500, 400);
                GUIUtil.centreOnWindow((Component)d);
                d.setVisible(true);
                if (!d.wasFinishPressed()) {
                    return null;
                }
                double minx = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MINX_KEY));
                double maxx = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MAXX_KEY));
                double miny = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MINY_KEY));
                double maxy = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MAXY_KEY));
                env = new Envelope(minx, maxx, miny, maxy);
            }
            this.worldFileHandler = new WorldFileHandler(fileName, this.allwaysLookForTFWExtension);
            this.worldFileHandler.writeWorldFile(env, imageDimensions.x, imageDimensions.y);
        }
        return env;
    }
}

