/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openjump.core.apitools.HandlerToMakeYourLifeEasier;

public class WorldFileHandler
implements HandlerToMakeYourLifeEasier {
    protected String worldFileName = null;
    protected String imageFileName = null;
    private boolean allwaysLookForTFWExtension = true;

    public WorldFileHandler(String imageFileName, boolean allwaysLookForTFWExtension) {
        this.imageFileName = imageFileName;
        this.allwaysLookForTFWExtension = allwaysLookForTFWExtension;
        this.worldFileName = this.isWorldFileExistentForImage();
        if (this.worldFileName == null) {
            this.worldFileName = (String)this.createListOfWorldFileNamesForImage().get(0);
        }
    }

    public boolean writeWorldFile(Envelope imageCoordinates, int imgWidth, int imgHeight) {
        double maxx = imageCoordinates.getMaxX();
        double minx = imageCoordinates.getMinX();
        double maxy = imageCoordinates.getMaxY();
        double miny = imageCoordinates.getMinY();
        try {
            FileWriter worldfileWriter = new FileWriter(this.worldFileName, false);
            double faktorA = (maxx - minx) / (double)imgWidth;
            double faktorB = 0.0;
            double faktorC = 0.0;
            double faktorD = (miny - maxy) / (double)imgHeight;
            double CoordX = minx;
            double CoordY = maxy;
            worldfileWriter.write(Double.toString(faktorA) + "\n");
            worldfileWriter.write(Double.toString(faktorB) + "\n");
            worldfileWriter.write(Double.toString(faktorC) + "\n");
            worldfileWriter.write(Double.toString(faktorD) + "\n");
            worldfileWriter.write(Double.toString(CoordX) + "\n");
            worldfileWriter.write(Double.toString(CoordY));
            worldfileWriter.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Envelope readWorldFile(int imgWidth, int imgHeight) {
        double CoordY;
        double CoordX;
        double faktorD;
        double faktorC;
        double faktorB;
        double faktorA;
        FileReader worldFileReader;
        try {
            worldFileReader = new FileReader(this.worldFileName);
        }
        catch (FileNotFoundException e1) {
            return null;
        }
        BufferedReader bufferedWorldFileReader = new BufferedReader(worldFileReader);
        String number = null;
        try {
            number = bufferedWorldFileReader.readLine().replaceAll("[,]", ".");
            faktorA = Double.parseDouble(number);
            number = bufferedWorldFileReader.readLine().replaceAll("[,]", ".");
            faktorB = Double.parseDouble(number);
            number = bufferedWorldFileReader.readLine().replaceAll("[,]", ".");
            faktorC = Double.parseDouble(number);
            number = bufferedWorldFileReader.readLine().replaceAll("[,]", ".");
            faktorD = Double.parseDouble(number);
            number = bufferedWorldFileReader.readLine().replaceAll("[,]", ".");
            CoordX = Double.parseDouble(number);
            number = bufferedWorldFileReader.readLine().replaceAll("[,]", ".");
            CoordY = Double.parseDouble(number);
        }
        catch (Exception e) {
            return null;
        }
        double minx = faktorA * 0.0 + faktorC * 0.0 + CoordX;
        double maxy = faktorB * 0.0 + faktorD * 0.0 + CoordY;
        double maxx = faktorA * (double)imgWidth + faktorC * (double)imgHeight + CoordX;
        double miny = faktorB * (double)imgWidth + faktorD * (double)imgHeight + CoordY;
        double px05x = (maxx - minx) / (double)imgWidth * 0.5;
        double px05y = (maxy - miny) / (double)imgHeight * 0.5;
        return new Envelope(minx -= px05x, maxx -= px05x, miny += px05y, maxy += px05y);
    }

    protected List createListOfWorldFileNamesForImage() {
        String worldFileName = this.imageFileName.substring(0, this.imageFileName.lastIndexOf("."));
        String imageExtension = this.imageFileName.substring(this.imageFileName.lastIndexOf(".") + 1).toLowerCase();
        ArrayList<String> possibleWorldFileNames = new ArrayList<String>();
        possibleWorldFileNames.add(worldFileName + "." + imageExtension.substring(0, 1) + imageExtension.substring(imageExtension.length() - 1) + "w");
        possibleWorldFileNames.add((worldFileName + "." + imageExtension.substring(0, 1) + imageExtension.substring(imageExtension.length() - 1) + "w").toUpperCase());
        possibleWorldFileNames.add(worldFileName + "." + imageExtension + "w");
        possibleWorldFileNames.add(worldFileName + "." + (imageExtension + "w").toUpperCase());
        if (this.allwaysLookForTFWExtension) {
            possibleWorldFileNames.add(worldFileName + ".tfw");
            possibleWorldFileNames.add(worldFileName + ".tfw".toUpperCase());
        }
        return possibleWorldFileNames;
    }

    public String isWorldFileExistentForImage() {
        List possibleWorldFileNames = this.createListOfWorldFileNamesForImage();
        File worldFile = null;
        for (int i = 0; i < possibleWorldFileNames.size(); ++i) {
            String wfName = (String)possibleWorldFileNames.get(i);
            worldFile = new File(wfName);
            if (!worldFile.exists()) continue;
            this.worldFileName = wfName;
            return this.worldFileName;
        }
        return null;
    }

    public boolean isAllwaysLookForTFWExtension() {
        return this.allwaysLookForTFWExtension;
    }

    public void setAllwaysLookForTFWExtension(boolean allwaysLookForTFWExtension) {
        this.allwaysLookForTFWExtension = allwaysLookForTFWExtension;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public String getWorldFileName() {
        return this.worldFileName;
    }
}

