/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit.helpclassesselection;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class SelectItemsByCircleTool
extends DragTool {
    private Shape selectedFeaturesShape;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private List verticesToSnap = null;
    private PlugInContext context = null;
    private double diameter = 0.0;
    private Point mp = null;

    public SelectItemsByCircleTool(PlugInContext context, double diameter, Coordinate initCoo) {
        this.context = context;
        this.diameter = diameter;
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
        this.calcuateCircle(initCoo);
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public Icon getIcon() {
        return IconLoader.icon((String)"");
    }

    public void mouseMoved(MouseEvent e) {
        try {
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        try {
            Point p;
            this.mp = p = new GeometryFactory().createPoint(this.getModelDestination());
            Geometry circle = p.buffer(this.diameter);
            this.selectItems(circle);
            Enumeration<AbstractButton> buttons = this.context.getWorkbenchContext().getWorkbench().getFrame().getToolBar().getButtonGroup().getElements();
            AbstractButton myButton = buttons.nextElement();
            int j = 0;
            while (buttons.hasMoreElements()) {
                myButton = buttons.nextElement();
                if (++j != 1) continue;
                myButton.doClick();
            }
            this.fireGestureFinished();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Collection verticesToSnap() {
        return this.verticesToSnap;
    }

    protected Shape getShape() throws Exception {
        this.calcuateCircle(this.modelDestination);
        return this.selectedFeaturesShape;
    }

    protected void setModelDestination(Coordinate modelDestination) {
        this.modelDestination = modelDestination;
    }

    private void calcuateCircle(Coordinate middlePoint) {
        Point p;
        this.mp = p = new GeometryFactory().createPoint(middlePoint);
        Geometry buffer = p.buffer(this.diameter);
        Geometry[] geomArray = new Geometry[]{buffer};
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(geomArray);
        try {
            this.selectedFeaturesShape = this.context.getLayerViewPanel().getJava2DConverter().toShape((Geometry)gc);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("SelectItemsByCircleTool:Exception " + e);
        }
    }

    private void selectItems(Geometry circle) {
        int count = 0;
        Layer[] selectedLayers = this.context.getLayerNamePanel().getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            Layer actualLayer = selectedLayers[i];
            FeatureCollection fc = this.context.getSelectedLayer(i).getFeatureCollectionWrapper().getWrappee();
            ArrayList<Feature> features = new ArrayList<Feature>();
            Iterator iter = fc.iterator();
            while (iter.hasNext()) {
                Feature element = (Feature)iter.next();
                if (circle.disjoint(element.getGeometry())) continue;
                features.add(element);
                ++count;
            }
            this.context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(actualLayer, features);
        }
        Collection myf = this.context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        this.context.getWorkbenchFrame().setTimeMessage(I18N.get("org.openjump.core.ui.plugin.edit.helpclassesselection.SelectItemsByCircleTool.layer-items") + ": " + count + ", " + I18N.get("org.openjump.core.ui.plugin.edit.helpclassesselection.SelectItemsByCircleTool.selected-items") + ": " + myf.size());
    }
}

