/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openjump.core.ui.plugin.edittoolbox.tab.ConstraintManager;

public abstract class ConstrainedDragTool
extends AbstractCursorTool {
    static final String lengthST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.length");
    static final String angleST = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.angle");
    static final String degrees = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.degrees");
    public static final int DEFAULT_VIEW_CLICK_BUFFER = 2;
    private int viewClickBuffer = 2;
    protected Coordinate modelSource = null;
    protected Coordinate modelDestination = null;
    private boolean dragApproved = false;
    protected List coordinates = new ArrayList();
    private Coordinate tentativeCoordinate;
    private ConstraintManager constraintManager;

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.dragApproved = true;
        try {
            this.setViewSource(e.getPoint());
        }
        catch (NoninvertibleTransformException x) {
            this.getPanel().getContext().handleThrowable((Throwable)x);
        }
    }

    protected void setViewClickBuffer(int clickBuffer) {
        this.viewClickBuffer = clickBuffer;
    }

    protected boolean wasClick() {
        return this.getModelSource().equals((Object)this.getModelDestination());
    }

    protected Envelope getBoxInModelCoordinates() throws NoninvertibleTransformException {
        double minX = Math.min(this.getModelSource().x, this.getModelDestination().x);
        double maxX = Math.max(this.getModelSource().x, this.getModelDestination().x);
        double minY = Math.min(this.getModelSource().y, this.getModelDestination().y);
        double maxY = Math.max(this.getModelSource().y, this.getModelDestination().y);
        if (this.wasClick()) {
            minX -= this.modelClickBuffer();
            maxX += this.modelClickBuffer();
            minY -= this.modelClickBuffer();
            maxY += this.modelClickBuffer();
        }
        return new Envelope(minX, maxX, minY, maxY);
    }

    protected double modelClickBuffer() {
        return (double)this.viewClickBuffer / this.getPanel().getViewport().getScale();
    }

    public void mouseDragged(MouseEvent e) {
        try {
            if (!this.dragApproved) {
                return;
            }
            this.mouseLocationChanged(e);
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Coordinate doConstraint(MouseEvent e) throws NoninvertibleTransformException {
        Coordinate retPt = this.snap(e.getPoint());
        retPt = this.constraintManager.constrain(this.getPanel(), this.getCoordinates(), retPt, e);
        return retPt;
    }

    public List getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    protected void mouseLocationChanged(MouseEvent e) {
        try {
            this.tentativeCoordinate = this.doConstraint(e);
            this.modelDestination = (Coordinate)this.tentativeCoordinate.clone();
            if (this.coordinates.isEmpty()) {
                return;
            }
            Coordinate startPt = (Coordinate)this.coordinates.get(this.coordinates.size() - 1);
            double length = startPt.distance(this.tentativeCoordinate);
            double angle = this.constraintManager.getBearing(startPt, this.tentativeCoordinate);
            DecimalFormat df2 = new DecimalFormat("##0.0#");
            DecimalFormat df3 = new DecimalFormat("###,###,##0.0##");
            this.getPanel().getContext().setStatusMessage(lengthST + ": " + df3.format(length) + ";  " + angleST + ": " + df2.format(angle) + " " + degrees);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Coordinate getModelSource() {
        return this.modelSource;
    }

    protected Coordinate getModelDestination() {
        return this.modelDestination;
    }

    protected void setModelSource(Coordinate source) {
        this.modelSource = source;
    }

    protected void setViewSource(Point2D source) throws NoninvertibleTransformException {
        this.setModelSource(this.getPanel().getViewport().toModelCoordinate(source));
    }

    public void mouseReleased(MouseEvent e) {
        try {
            boolean dragComplete = this.isShapeOnScreen();
            this.clearShape();
            if (dragComplete) {
                this.fireGestureFinished();
            }
            this.dragApproved = false;
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    protected Shape getShape() throws Exception {
        return this.getShape(this.getViewSource(), this.getViewDestination());
    }

    protected Point2D getViewSource() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(this.getModelSource());
    }

    protected Point2D getViewDestination() throws NoninvertibleTransformException {
        return this.getPanel().getViewport().toViewPoint(this.getModelDestination());
    }

    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        double minX = Math.min(source.getX(), destination.getX());
        double minY = Math.min(source.getY(), destination.getY());
        double maxX = Math.max(source.getX(), destination.getX());
        double maxY = Math.max(source.getY(), destination.getY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        this.constraintManager = new ConstraintManager(this.getWorkbench().getContext());
    }
}

