/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedDragTool;

public class ConstrainedMoveVertexTool
extends ConstrainedDragTool {
    static final String constrainedMoveVertex = I18N.get("org.openjump.core.ui.plugin.edittoolbox.ConstrainedMoveVertexTool.Constrained-Move-Vertex");
    static final String noEditableSelectionHandlesHere = I18N.get("org.openjump.core.ui.plugin.edittoolbox.ConstrainedMoveVertexTool.No-editable-selection-handles-here");
    public static final int TOLERANCE = 5;
    private EnableCheckFactory checkFactory;
    private Coordinate prevPoint = null;
    private Coordinate nextPoint = null;

    public ConstrainedMoveVertexTool(EnableCheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.setColor(new Color(194, 179, 205));
        this.setStroke(new BasicStroke(5.0f));
        this.allowSnapping();
    }

    public Cursor getCursor() {
        return ConstrainedMoveVertexTool.createCursor((Image)IconLoader.icon((String)"MoveVertexCursor3.gif").getImage());
    }

    public Icon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("MoveVertexConstrained.gif"));
    }

    public String getName() {
        return constrainedMoveVertex;
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        this.moveVertices(this.getModelSource(), this.getModelDestination());
    }

    public void mousePressed(final MouseEvent e) {
        try {
            if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
                return;
            }
            if (!this.check(this.checkFactory.createExactlyNItemsMustBeSelectedCheck(1))) {
                return;
            }
            if (!this.check(new EnableCheck(){

                public String check(JComponent component) {
                    try {
                        return !ConstrainedMoveVertexTool.this.nearSelectionHandle(e.getPoint()) ? noEditableSelectionHandlesHere : null;
                    }
                    catch (Exception e2) {
                        return e2.toString();
                    }
                }
            })) {
                return;
            }
            super.mousePressed(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private boolean nearSelectionHandle(Point2D p) throws NoninvertibleTransformException {
        final Envelope buffer = this.vertexBuffer(this.getPanel().getViewport().toModelCoordinate(p));
        final boolean[] result = new boolean[]{false};
        for (Layer layer : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            if (!layer.isEditable()) continue;
            for (Geometry item : this.getPanel().getSelectionManager().getSelectedItems(layer)) {
                item.apply(new CoordinateFilter(){

                    public void filter(Coordinate coord) {
                        if (buffer.contains(coord)) {
                            result[0] = true;
                        }
                    }
                });
                if (!result[0]) continue;
                this.getCoordinates(item, buffer);
            }
        }
        return result[0];
    }

    private int getVertexIndex(LineString poly, Envelope buffer) {
        int numPts = poly.getNumPoints();
        for (int i = 0; i < numPts; ++i) {
            if (!buffer.contains(poly.getCoordinateN(i))) continue;
            return i;
        }
        return 0;
    }

    private void loadLine(LineString line, Envelope buffer) {
        if (line != null) {
            int numPts = line.getNumPoints();
            int vertexIndex = this.getVertexIndex(line, buffer);
            for (int i = 0; i < vertexIndex; ++i) {
                this.coordinates.add(line.getCoordinateN(i));
            }
            this.prevPoint = vertexIndex == 0 ? null : line.getCoordinateN(vertexIndex - 1);
            this.nextPoint = vertexIndex == line.getNumPoints() - 1 ? null : line.getCoordinateN(vertexIndex + 1);
        }
    }

    private void loadPoly(LineString poly, Envelope buffer) {
        if (poly != null) {
            int numPts = poly.getNumPoints();
            int vertexIndex = this.getVertexIndex(poly, buffer);
            int startPt = vertexIndex + 2 - numPts;
            int endPt = vertexIndex - 1;
            if (vertexIndex == 0) {
                endPt = numPts - 2;
            }
            for (int i = startPt; i <= endPt; ++i) {
                int index = i;
                if (index < 0) {
                    index += numPts - 1;
                }
                this.coordinates.add(poly.getCoordinateN(index));
            }
            this.prevPoint = (Coordinate)this.coordinates.get(0);
            this.nextPoint = (Coordinate)this.coordinates.get(this.coordinates.size() - 1);
        }
    }

    private void getCoordinates(Geometry geometry, Envelope buffer) {
        this.coordinates.clear();
        if (geometry instanceof LineString) {
            this.loadLine((LineString)geometry, buffer);
            return;
        }
        if (geometry instanceof LinearRing) {
            this.loadPoly((LineString)((LinearRing)geometry), buffer);
            return;
        }
        if (geometry instanceof Polygon) {
            this.loadPoly(((Polygon)geometry).getExteriorRing(), buffer);
            return;
        }
        if (geometry instanceof MultiPoint) {
            this.coordinates.add(((Point)geometry).getCoordinate());
            this.prevPoint = null;
            this.nextPoint = null;
            return;
        }
    }

    private Envelope vertexBuffer(Coordinate c) throws NoninvertibleTransformException {
        double tolerance = 5.0 / this.getPanel().getViewport().getScale();
        return this.vertexBuffer(c, tolerance);
    }

    public void moveVertices(Coordinate initialLocation, Coordinate finalLocation) throws Exception {
        Envelope oldVertexBuffer = this.vertexBuffer(initialLocation);
        Coordinate newVertex = finalLocation;
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
            if (!layerWithSelectedItems.isEditable()) continue;
            transactions.add(this.createTransaction(layerWithSelectedItems, oldVertexBuffer, newVertex));
        }
        EditTransaction.commit(transactions);
    }

    private EditTransaction createTransaction(Layer layer, final Envelope oldVertexBuffer, final Coordinate newVertex) {
        return EditTransaction.createTransactionOnSelection((EditTransaction.SelectionEditor)new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    this.edit(item);
                }
                return geometryWithSelectedItems;
            }

            private void edit(Geometry selectedItem) {
                selectedItem.apply(new CoordinateFilter(){

                    public void filter(Coordinate coordinate) {
                        if (oldVertexBuffer.contains(coordinate)) {
                            coordinate.x = newVertex.x;
                            coordinate.y = newVertex.y;
                        }
                    }
                });
            }
        }, (SelectionManagerProxy)this.getPanel(), (LayerViewPanelContext)this.getPanel().getContext(), (String)this.getName(), (Layer)layer, (boolean)this.isRollingBackInvalidEdits(), (boolean)false);
    }

    protected Shape getShape(Point2D source, Point2D destination) throws Exception {
        if (this.prevPoint == null && this.nextPoint == null) {
            double radius = 20.0;
            return new Ellipse2D.Double(destination.getX() - radius / 2.0, destination.getY() - radius / 2.0, radius, radius);
        }
        GeneralPath path = new GeneralPath();
        if (this.prevPoint == null) {
            path.moveTo((int)destination.getX(), (int)destination.getY());
        } else {
            Point2D firstPoint = this.getPanel().getViewport().toViewPoint(this.prevPoint);
            path.moveTo((float)firstPoint.getX(), (float)firstPoint.getY());
            path.lineTo((int)destination.getX(), (int)destination.getY());
        }
        if (this.nextPoint != null) {
            Point2D lastPoint = this.getPanel().getViewport().toViewPoint(this.nextPoint);
            path.lineTo((int)lastPoint.getX(), (int)lastPoint.getY());
        }
        return path;
    }

    private Envelope vertexBuffer(Coordinate vertex, double tolerance) {
        return new Envelope(vertex.x - tolerance, vertex.x + tolerance, vertex.y - tolerance, vertex.y + tolerance);
    }
}

