/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.core.geomutils.GeoUtils;

public class ScaleSelectedItemsTool
extends DragTool {
    private String scaleSelectedItems = "Scale Selected Items";
    private String sScaleFactor = "scale factor";
    private EnableCheckFactory checkFactory;
    private Shape selectionBBoxShape;
    private Geometry originalItemsAsLines = null;
    private Geometry outlineItems = null;
    private Shape outlineItemsShape = null;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private List verticesToSnap = null;
    private Coordinate centerCoord;
    private Geometry originalBBox = null;
    private double xscale = 0.0;
    private double yscale = 0.0;
    private Coordinate mousePos = null;
    private Coordinate center = null;
    DecimalFormat df2 = new DecimalFormat("##0.0#");
    boolean startScaling = false;
    double toleranceFactor = 2.0;
    private BasicStroke originalStroke = null;
    boolean somethingChanged = false;
    int style = 1;
    Cursor cursor2 = ScaleSelectedItemsTool.createCursor((Image)IconLoader.icon((String)"MoveVertexCursor.gif").getImage());
    Cursor cursor1 = null;

    public ScaleSelectedItemsTool(EnableCheckFactory checkFactory) {
        this.scaleSelectedItems = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.ScaleSelectedItemsTool.Scale-Selected-Items");
        this.sScaleFactor = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.ScaleSelectedItemsTool.scale-factor");
        this.checkFactory = checkFactory;
        this.originalStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
        this.setStroke(this.originalStroke);
        this.style = 1;
        this.allowSnapping();
        this.cursor1 = this.getCursor();
    }

    protected void gestureFinished() throws Exception {
        if (this.startScaling) {
            this.reportNothingToUndoYet();
            ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
            for (Layer layerWithSelectedItems : this.getPanel().getSelectionManager().getLayersWithSelectedItems()) {
                transactions.add(this.createTransaction(layerWithSelectedItems));
            }
            EditTransaction.commit(transactions);
            this.startScaling = false;
            this.originalBBox = this.createSelectedItemsBoundingBox();
            this.outlineItemsShape = this.selectionBBoxShape = this.getPanel().getJava2DConverter().toShape(this.originalBBox);
            this.startScaling = false;
            this.somethingChanged = true;
        }
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection((EditTransaction.SelectionEditor)new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    ScaleSelectedItemsTool.this.scale(item);
                }
                return geometryWithSelectedItems;
            }
        }, (SelectionManagerProxy)this.getPanel(), (LayerViewPanelContext)this.getPanel().getContext(), (String)this.getName(), (Layer)layer, (boolean)this.isRollingBackInvalidEdits(), (boolean)false);
        return transaction;
    }

    private void scale(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                coordinate.x = ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.x + ScaleSelectedItemsTool.this.xscale * (coordinate.x - ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.x);
                coordinate.y = ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.y + ScaleSelectedItemsTool.this.yscale * (coordinate.y - ((ScaleSelectedItemsTool)ScaleSelectedItemsTool.this).center.y);
            }
        });
    }

    public Icon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("ScalePolygon.gif"));
    }

    public String getName() {
        return this.scaleSelectedItems;
    }

    public void activate(LayerViewPanel panel) {
        super.activate(panel);
        try {
            this.originalBBox = this.createSelectedItemsBoundingBox();
            this.outlineItemsShape = this.selectionBBoxShape = this.getPanel().getJava2DConverter().toShape(this.originalBBox);
            this.setStroke(this.originalStroke);
            this.setColor(Color.RED);
            this.style = 1;
            this.somethingChanged = true;
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.setStroke(this.originalStroke);
        this.setColor(Color.RED);
        this.style = 1;
        try {
            this.setMousePos(this.getPanel().getViewport().toModelCoordinate((Point2D)e.getPoint()));
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
        double tolerance = (double)SnapManager.getToleranceInPixels((Blackboard)this.getWorkbench().getBlackboard()) / this.getPanel().getViewport().getScale();
        LineString ls = (LineString)this.originalBBox.getBoundary();
        MultiPoint mps = new GeometryFactory().createMultiPoint(ls.getCoordinates());
        Geometry buffergeom = mps.buffer(tolerance * this.toleranceFactor);
        Point mousep = new GeometryFactory().createPoint(this.mousePos);
        if (buffergeom.contains((Geometry)mousep)) {
            try {
                if (!this.check(this.checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1))) {
                    return;
                }
                if (!this.check(this.checkFactory.createSelectedItemsLayersMustBeEditableCheck())) {
                    return;
                }
                this.verticesToSnap = null;
                super.mousePressed(e);
                this.setSelectedItemsOutlines();
                this.originalBBox = this.createSelectedItemsBoundingBox();
                LineString lsBBox = (LineString)this.originalBBox.getBoundary();
                this.outlineItems = this.originalItemsAsLines.union((Geometry)lsBBox);
                this.outlineItemsShape = this.getPanel().getJava2DConverter().toShape(this.outlineItems);
                this.center = this.getFarestPoint(this.originalBBox, this.mousePos);
                this.startScaling = true;
                this.somethingChanged = true;
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.startScaling) {
            super.mouseDragged(e);
            try {
                this.setMousePos(this.getPanel().getViewport().toModelCoordinate((Point2D)e.getPoint()));
                double dxMouse = Math.abs(this.center.x - this.mousePos.x);
                double dyMouse = Math.abs(this.center.y - this.mousePos.y);
                this.xscale = dxMouse / this.originalBBox.getEnvelopeInternal().getWidth();
                this.yscale = dyMouse / this.originalBBox.getEnvelopeInternal().getHeight();
                if (e.isShiftDown()) {
                    this.yscale = this.xscale;
                }
                this.getPanel().getContext().setStatusMessage(this.sScaleFactor + " x: " + this.df2.format(this.xscale) + "  " + this.sScaleFactor + " y: " + this.df2.format(this.yscale));
                Geometry geoms = (Geometry)this.outlineItems.clone();
                this.scale(geoms);
                this.outlineItemsShape = this.getPanel().getJava2DConverter().toShape(geoms);
                this.somethingChanged = true;
            }
            catch (Throwable t) {
                this.getPanel().getContext().handleThrowable(t);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        try {
            this.setMousePos(this.getPanel().getViewport().toModelCoordinate((Point2D)e.getPoint()));
            double tolerance = (double)SnapManager.getToleranceInPixels((Blackboard)this.getWorkbench().getBlackboard()) / this.getPanel().getViewport().getScale();
            LineString ls = (LineString)this.originalBBox.getBoundary();
            MultiPoint mps = new GeometryFactory().createMultiPoint(ls.getCoordinates());
            Geometry buffergeom = mps.buffer(tolerance * this.toleranceFactor);
            Point mousep = new GeometryFactory().createPoint(this.mousePos);
            if (buffergeom.contains((Geometry)mousep)) {
                if (this.style == 1) {
                    this.getPanel().setCursor(this.cursor2);
                    this.style = 2;
                    this.somethingChanged = true;
                }
            } else if (this.style == 2) {
                this.getPanel().setCursor(this.cursor1);
                this.style = 1;
                this.somethingChanged = true;
            }
            if (this.somethingChanged) {
                this.redrawShape();
                this.somethingChanged = false;
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private Geometry createSelectedItemsBoundingBox() {
        Collection selectedGeos = this.getPanel().getSelectionManager().getSelectedItems();
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        int count = 0;
        for (Geometry element : selectedGeos) {
            if (count == 0) {
                xmin = element.getEnvelopeInternal().getMinX();
                xmax = element.getEnvelopeInternal().getMaxX();
                ymin = element.getEnvelopeInternal().getMinY();
                ymax = element.getEnvelopeInternal().getMaxY();
            } else {
                if (element.getEnvelopeInternal().getMinX() < xmin) {
                    xmin = element.getEnvelopeInternal().getMinX();
                }
                if (element.getEnvelopeInternal().getMaxX() > xmax) {
                    xmax = element.getEnvelopeInternal().getMaxX();
                }
                if (element.getEnvelopeInternal().getMinY() < ymin) {
                    ymin = element.getEnvelopeInternal().getMinY();
                }
                if (element.getEnvelopeInternal().getMaxY() > ymax) {
                    ymax = element.getEnvelopeInternal().getMaxY();
                }
            }
            ++count;
        }
        Coordinate[] coords = new Coordinate[]{new Coordinate(xmin, ymin), new Coordinate(xmin, ymax), new Coordinate(xmax, ymax), new Coordinate(xmax, ymin), new Coordinate(xmin, ymin)};
        LinearRing ring = new GeometryFactory().createLinearRing(coords);
        Polygon geo = new GeometryFactory().createPolygon(ring, null);
        this.centerCoord = geo.getCentroid().getCoordinate();
        return geo;
    }

    private void setSelectedItemsOutlines() throws NoninvertibleTransformException {
        Collection selectedGeos = this.getPanel().getSelectionManager().getSelectedItems();
        Geometry geo = null;
        for (Geometry element : selectedGeos) {
            if (geo == null) {
                if (element instanceof Polygon) {
                    geo = element.getBoundary();
                    continue;
                }
                geo = (Geometry)element.clone();
                continue;
            }
            if (element instanceof Polygon) {
                geo = geo.union(element.getBoundary());
                continue;
            }
            geo = geo.union((Geometry)element.clone());
        }
        this.originalItemsAsLines = geo;
    }

    protected Shape getShape() {
        return this.outlineItemsShape;
    }

    public void deactivate(MouseEvent e) {
        super.deactivate();
        this.cleanup((Graphics2D)this.getPanel().getGraphics());
    }

    protected void setMousePos(Coordinate destination) {
        this.mousePos = this.snap(destination);
    }

    private Coordinate getFarestPoint(Geometry box, Coordinate point) {
        Coordinate farestp = null;
        double maxDist = 0.0;
        double dist = 0.0;
        Coordinate[] coords = box.getCoordinates();
        for (int i = 0; i < coords.length; ++i) {
            dist = GeoUtils.distance(coords[i], point);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
            farestp = (Coordinate)coords[i].clone();
        }
        return farestp;
    }
}

