/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadQueue;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collection;

public class LayerPrinter2 {
    private RenderingManager renderingManager;
    private Graphics2D graphics;
    private LayerViewPanel panel = null;

    public LayerViewPanel getLayerViewPanel() {
        return this.panel;
    }

    public BufferedImage print(Collection layers, Envelope envelope, int extentInPixels) throws Exception {
        int extentInPixelsY;
        int extentInPixelsX;
        double height;
        final Throwable[] throwable = new Throwable[]{null};
        this.panel = new LayerViewPanel(!layers.isEmpty() ? ((Layer)layers.iterator().next()).getLayerManager() : new LayerManager(), new LayerViewPanelContext(){

            public void setStatusMessage(String message) {
            }

            public void warnUser(String warning) {
            }

            public void handleThrowable(Throwable t) {
                throwable[0] = t;
            }
        });
        double width = envelope.getWidth();
        if (width > (height = envelope.getHeight())) {
            extentInPixelsX = extentInPixels;
            extentInPixelsY = (int)Math.round(height / width * (double)extentInPixels);
        } else {
            extentInPixelsY = extentInPixels;
            extentInPixelsX = (int)Math.round(width / height * (double)extentInPixels);
        }
        this.panel.setSize(extentInPixelsX, extentInPixelsY);
        this.panel.getViewport().zoom(envelope);
        BufferedImage bufferedImage = new BufferedImage(this.panel.getWidth(), this.panel.getHeight(), 1);
        this.graphics = bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintBackground(this.graphics, extentInPixelsX, extentInPixelsY);
        this.renderingManager = this.panel.getRenderingManager();
        this.renderingManager.renderAll();
        ThreadQueue runningThreads = this.renderingManager.getDefaultRendererThreadQueue();
        while (runningThreads.getRunningThreads() > 0) {
            Thread.sleep(200L);
        }
        this.renderingManager.copyTo(this.graphics);
        if (throwable[0] != null) {
            throw throwable[0] instanceof Exception ? (Exception)throwable[0] : new Exception(throwable[0].getMessage());
        }
        this.panel.dispose();
        return bufferedImage;
    }

    private void paintBackground(Graphics2D graphics, int extentX, int extentY) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, extentX, extentY);
    }
}

