/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.JFileChooser;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveImageAsSVGPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    File selFile = null;

    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix((PlugIn)this, new String[]{MenuNames.FILE, MenuNames.FILE_SAVEVIEW}, I18N.get("org.openjump.core.ui.plugin.file.SaveImageAsSVGPlugIn.save-image-in-svg-format") + "{pos:10}", false, null, (EnableCheck)SaveImageAsSVGPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public boolean execute(PlugInContext context) throws Exception {
        JFileChooser fc = GUIUtil.createJFileChooserWithOverwritePrompting((String)"svg");
        fc.showSaveDialog((Component)context.getWorkbenchFrame());
        File file = fc.getSelectedFile();
        try {
            File newFile;
            String name = file.getPath();
            name = this.addExtension(name, "svg");
            this.selFile = newFile = new File(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        LayerRenderer myRnew;
        Renderer myR;
        Layer layer;
        int i;
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        LayerViewPanel lvp = context.getLayerViewPanel();
        RenderingManager rms = lvp.getRenderingManager();
        List layers = context.getLayerManager().getVisibleLayers(false);
        for (i = 0; i < layers.size(); ++i) {
            layer = (Layer)layers.get(i);
            myR = rms.getRenderer((Object)layer);
            if (!(myR instanceof LayerRenderer)) continue;
            myRnew = (LayerRenderer)myR;
            myRnew.setMaxFeatures(10000);
        }
        lvp.repaint();
        lvp.paintComponent((Graphics)svgGenerator);
        for (i = 0; i < layers.size(); ++i) {
            layer = (Layer)layers.get(i);
            myR = rms.getRenderer((Object)layer);
            if (!(myR instanceof LayerRenderer)) continue;
            myRnew = (LayerRenderer)myR;
            myRnew.setMaxFeatures(100);
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.selFile, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            svgGenerator.stream(out, true);
            out.close();
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("error:" + e.getMessage());
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(0));
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }
}

