/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.wizard.AbstractWizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.openjump.swing.listener.InvokeMethodActionListener;
import org.openjump.swing.listener.InvokeMethodListSelectionListener;
import org.openjump.swing.util.SpringUtilities;

public class ChooseProjectPanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = -1681453503884354145L;
    private WorkbenchContext workbenchContext;
    private JList projectList;
    private JRadioButton newButton;
    private JRadioButton existingButton;
    private WeakReference<TaskFrame> selectedTaskFrame;

    public ChooseProjectPanel(WorkbenchContext workbenchContext, String nextId) {
        this.workbenchContext = workbenchContext;
        this.setNextID(nextId);
        this.setLayout(new BorderLayout());
        JPanel view = new JPanel(new SpringLayout());
        this.newButton = new JRadioButton("New Project");
        this.newButton.setSelected(true);
        view.add(this.newButton);
        this.existingButton = new JRadioButton("Existing Project");
        view.add(this.existingButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.newButton);
        group.add(this.existingButton);
        this.projectList = new JList(new DefaultListModel());
        JScrollPane listScroller = new JScrollPane(this.projectList);
        listScroller.setPreferredSize(new Dimension(300, 150));
        view.add(listScroller);
        SpringUtilities.makeCompactGrid(view, 3, 1, 5, 5, 5, 5);
        InvokeMethodActionListener actionListener = new InvokeMethodActionListener((Object)this, "updateButtons");
        this.newButton.addActionListener(actionListener);
        this.existingButton.addActionListener(actionListener);
        this.projectList.addListSelectionListener(new InvokeMethodListSelectionListener((Object)this, "listSelected", true));
        this.add(new JScrollPane(view), "Center");
    }

    public void enteredFromLeft(Map data) {
        super.enteredFromLeft(data);
        DefaultListModel model = (DefaultListModel)this.projectList.getModel();
        this.projectList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText(((TaskFrame)value).getTask().getName());
                return this;
            }
        });
        model.removeAllElements();
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame workbenchFrame = workbench.getFrame();
        JDesktopPane desktopPane = workbenchFrame.getDesktopPane();
        for (JInternalFrame frame : desktopPane.getAllFrames()) {
            if (!(frame instanceof TaskFrame)) continue;
            TaskFrame taskFrame = (TaskFrame)frame;
            model.addElement(taskFrame);
        }
    }

    public void exitingToRight() throws Exception {
        TaskFrame taskFrame = (TaskFrame)this.projectList.getSelectedValue();
        this.selectedTaskFrame = taskFrame != null ? new WeakReference<TaskFrame>(taskFrame) : null;
        DefaultListModel model = (DefaultListModel)this.projectList.getModel();
        model.removeAllElements();
    }

    public boolean hasActiveTaskFrame() {
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame workbenchFrame = workbench.getFrame();
        JInternalFrame activeFrame = workbenchFrame.getActiveInternalFrame();
        return activeFrame instanceof TaskFrame && !activeFrame.isIcon();
    }

    public boolean hasTaskFrames() {
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame workbenchFrame = workbench.getFrame();
        JDesktopPane desktopPane = workbenchFrame.getDesktopPane();
        for (JInternalFrame frame : desktopPane.getAllFrames()) {
            if (!(frame instanceof TaskFrame)) continue;
            return true;
        }
        return false;
    }

    public void setNextID(String nextId) {
        super.setNextID(nextId);
    }

    public void updateButtons() {
        if (this.newButton.isSelected()) {
            this.projectList.getSelectionModel().clearSelection();
        } else if (this.projectList.getSelectedIndex() == -1) {
            this.projectList.setSelectedIndex(0);
        }
    }

    public void listSelected() {
        if (this.projectList.getSelectedIndex() == -1) {
            this.newButton.setSelected(true);
        } else {
            this.existingButton.setSelected(true);
        }
    }

    public void activateSelectedProject() {
        if (!this.hasActiveTaskFrame()) {
            JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
            WorkbenchFrame frame = workbench.getFrame();
            if (this.selectedTaskFrame == null) {
                frame.addTaskFrame();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TaskFrame taskFrame = (TaskFrame)ChooseProjectPanel.this.selectedTaskFrame.get();
                        try {
                            taskFrame.setSelected(true);
                        }
                        catch (PropertyVetoException e) {
                            // empty catch block
                        }
                        if (taskFrame.isIcon()) {
                            try {
                                taskFrame.setIcon(false);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
    }
}

