/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openjump.core.ui.plugin.file.FindFile;
import org.openjump.core.ui.plugin.file.OpenRecentPlugIn;
import org.openjump.core.ui.plugin.file.open.SelectProjectFilesPanel;
import org.openjump.core.ui.swing.wizard.AbstractWizardGroup;

public class OpenProjectWizard
extends AbstractWizardGroup {
    public static final String KEY = OpenProjectWizard.class.getName();
    private WorkbenchContext workbenchContext;
    private SelectProjectFilesPanel selectProjectPanel;
    private Task sourceTask;
    private Task newTask;
    private File[] files;

    public OpenProjectWizard(WorkbenchContext workbenchContext) {
        super(I18N.get(KEY), IconLoader.icon((String)"Open.gif"), SelectProjectFilesPanel.KEY);
        this.workbenchContext = workbenchContext;
        this.initPanels(workbenchContext);
    }

    public OpenProjectWizard(WorkbenchContext workbenchContext, File[] files) {
        this.workbenchContext = workbenchContext;
        this.files = files;
        this.initPanels(workbenchContext);
    }

    private void initPanels(WorkbenchContext workbenchContext) {
        this.selectProjectPanel = new SelectProjectFilesPanel(workbenchContext);
        this.addPanel(this.selectProjectPanel);
    }

    public void initialize(WorkbenchContext workbenchContext, WizardDialog dialog) {
        this.selectProjectPanel.setDialog(dialog);
    }

    public void run(WizardDialog dialog, TaskMonitor monitor) {
        if (this.files == null) {
            File[] selectedFiles = this.selectProjectPanel.getSelectedFiles();
            this.open(selectedFiles, monitor);
        } else {
            this.open(this.files, monitor);
        }
    }

    private void open(File[] files, TaskMonitor monitor) {
        for (File file : files) {
            this.open(file, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file, TaskMonitor monitor) {
        try {
            FileReader reader = new FileReader(file);
            try {
                JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
                WorkbenchFrame workbenchFrame = workbench.getFrame();
                PlugInManager plugInManager = workbench.getPlugInManager();
                ClassLoader pluginClassLoader = plugInManager.getClassLoader();
                this.sourceTask = (Task)new XML2Java(pluginClassLoader).read(reader, Task.class);
                this.initializeDataSources(this.sourceTask, workbenchFrame.getContext());
                this.newTask = new Task();
                this.newTask.setName(GUIUtil.nameWithoutExtension((File)file));
                this.newTask.setProjectFile(file);
                this.newTask.setProperties(this.sourceTask.getProperties());
                workbenchFrame.addTaskFrame(this.newTask);
                LayerManager sourceLayerManager = this.sourceTask.getLayerManager();
                LayerManager newLayerManager = this.newTask.getLayerManager();
                CoordinateSystemRegistry crsRegistry = CoordinateSystemRegistry.instance(this.workbenchContext.getBlackboard());
                this.loadLayers(sourceLayerManager, newLayerManager, crsRegistry, monitor);
                OpenRecentPlugIn.get(this.workbenchContext).addRecentProject(file);
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            monitor.report(e);
        }
    }

    private void initializeDataSources(Task task, WorkbenchContext context) {
        LayerManager layerManager = task.getLayerManager();
        List layers = layerManager.getLayers();
        for (Layer layer : layers) {
            DataSourceQuery dataSourceQuery = layer.getDataSourceQuery();
            DataSource dataSource = dataSourceQuery.getDataSource();
            if (!(dataSource instanceof WorkbenchContextReference)) continue;
            WorkbenchContextReference workbenchRef = (WorkbenchContextReference)dataSource;
            workbenchRef.setWorkbenchContext(context);
        }
    }

    private void loadLayers(LayerManager sourceLayerManager, LayerManager newLayerManager, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        JUMPWorkbench workbench = this.workbenchContext.getWorkbench();
        WorkbenchFrame workbenchFrame = workbench.getFrame();
        FindFile findFile = new FindFile((Component)workbenchFrame);
        boolean displayDialog = true;
        List categories = sourceLayerManager.getCategories();
        block2: for (Category sourceLayerCategory : categories) {
            newLayerManager.addCategory(sourceLayerCategory.getName());
            ArrayList layerables = new ArrayList(sourceLayerCategory.getLayerables());
            Collections.reverse(layerables);
            for (Layerable layerable : layerables) {
                if (monitor != null) {
                    monitor.report(I18N.get("ui.plugin.OpenProjectPlugIn.loading") + " " + layerable.getName());
                }
                layerable.setLayerManager(newLayerManager);
                if (layerable instanceof Layer) {
                    Layer layer = (Layer)layerable;
                    try {
                        OpenProjectWizard.load(layer, registry, monitor);
                    }
                    catch (FileNotFoundException ex) {
                        DataSourceQuery dataSourceQuery;
                        DataSource dataSource;
                        Map properties;
                        String fname;
                        String filename;
                        if (displayDialog) {
                            displayDialog = false;
                            int response = JOptionPane.showConfirmDialog((Component)workbenchFrame, I18N.get("ui.plugin.OpenProjectPlugIn.At-least-one-file-in-the-task-could-not-be-found") + "\n" + I18N.get("ui.plugin.OpenProjectPlugIn.Do-you-want-to-locate-it-and-continue-loading-the-task"), "JUMP", 0);
                            if (response != 0) continue block2;
                        }
                        if ((filename = findFile.getFileName(fname = (properties = (dataSource = (dataSourceQuery = layer.getDataSourceQuery()).getDataSource()).getProperties()).get("File").toString())).length() <= 0) continue block2;
                        properties.put("File", filename);
                        dataSource.setProperties(properties);
                        OpenProjectWizard.load(layer, registry, monitor);
                    }
                }
                newLayerManager.addLayerable(sourceLayerCategory.getName(), layerable);
            }
        }
    }

    public static void load(Layer layer, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        DataSourceQuery dataSourceQuery = layer.getDataSourceQuery();
        String query = dataSourceQuery.getQuery();
        DataSource dataSource = dataSourceQuery.getDataSource();
        FeatureCollection features = OpenProjectWizard.executeQuery(query, dataSource, registry, monitor);
        layer.setFeatureCollection(features);
        layer.setFeatureCollectionModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureCollection executeQuery(String query, DataSource dataSource, CoordinateSystemRegistry registry, TaskMonitor monitor) throws Exception {
        Connection connection = dataSource.getConnection();
        try {
            FeatureCollection features = connection.executeQuery(query, monitor);
            FeatureCollection featureCollection = dataSource.installCoordinateSystem(features, registry);
            return featureCollection;
        }
        finally {
            connection.close();
        }
    }
}

